package eu.dnetlib.data.collector.plugins.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;

public class UbiEratLupaHttpCollectorPlugin implements CollectorPlugin {
	
	@Override
	public Iterable<String> collect(final InterfaceDescriptor interfaceDescriptor, final String fromDate, final String untilDate) throws CollectorServiceException {
		final String baseUrl = interfaceDescriptor.getBaseUrl();
		
		if((baseUrl == null) || baseUrl.isEmpty())
			throw new CollectorServiceException("Param 'baseurl' is null or empty");
		
		return new Iterable<String>() {
			@Override
			public Iterator<String> iterator() {
				return new UbiEratLupaIterator(baseUrl);
			}
		};
	}

	@Override
	public String getProtocol() {
		return "http-lupa";
	}

	@Override
	public List<String> listNameParameters() {
		return new ArrayList<String>();
	}

}
