<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="readMDStore"/>
	</ARCS>
</NODE>

<NODE name="readMDStore" type="ReadMDStore">
	<DESCRIPTION>Read from mdstore</DESCRIPTION>
	<PARAMETERS>
		<PARAM name="eprParam" managedBy="system" type="string" required="true">oai_epr</PARAM>
		<PARAM name="mdFormatName" managedBy="system" type="string" required="true">$params.("clean_format")$</PARAM>
		<PARAM name="mdFormatLayout" managedBy="system" type="string" required="true">$params.("clean_layout")$</PARAM>
		<PARAM name="mdFormatInterpretation" managedBy="system" type="string" required="true">$params.("clean_interpretation")$</PARAM>
		<PARAM name="datasource" managedBy="system" type="string" required="true">$params.("dataprovider:id")$</PARAM>
		<PARAM name="mdstoreId" managedBy="system" type="string" required="true">$params.("clean_id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="oaiSync" />
	</ARCS>
</NODE>

<NODE name="oaiSync" type="SyncOAIStores">
	<DESCRIPTION>Synchronizes OAI stores</DESCRIPTION>
	<PARAMETERS>
		<PARAM name="eprParam" managedBy="system" type="string" required="true">oai_epr</PARAM>
		<PARAM name="oai_dbName" managedBy="system" type="string" required="true">oaistore</PARAM>
		<PARAM name="formatParam" managedBy="user" type="string" required="true">oai_formatName</PARAM>
		<PARAM name="layoutParam" managedBy="user" type="string" required="true">oai_formatLayout</PARAM>
		<PARAM name="interpretationParam" managedBy="user" type="string" required="true">oai_formatInterpretation</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success" />
	</ARCS>
</NODE>