package eu.dnetlib.msro.eagle.workflows.nodes.composition;

import java.io.StringReader;
import java.util.Iterator;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class ComposeEprJobNode  extends SimpleJobNode {
	
	private static final Log log = LogFactory.getLog(ComposeEprJobNode.class);

	private String mainEprParam;
	private String alternateEprParam;
	private String xpathToReplacedFragment;
	private String xpathToReplacingFragment;
	private String outputEprParam;
	
	private MappedResultSetFactory mappedResultSetFactory;
	private ResultSetClientFactory resultSetClientFactory;
	
	@Override
	protected String execute(final NodeToken token) throws Exception {
		final W3CEndpointReference inputEpr = new EPRUtils().getEpr(token.getEnv().getAttribute(mainEprParam));
		final Iterator<String> alternateRsClient = resultSetClientFactory.getClient(token.getEnv().getAttribute(alternateEprParam)).iterator();
		final SAXReader reader = new SAXReader();
		
		final W3CEndpointReference outputEpr = mappedResultSetFactory.createMappedResultSet(inputEpr, new UnaryFunction<String, String>() {

			@Override
			public String evaluate(String current) {
				try {
					Document main = reader.read(new StringReader(current));
					Document alternate = reader.read(new StringReader(alternateRsClient.next()));
					compose(main, alternate);
					return main.asXML();
				} catch (DocumentException e) {
					log.error("Error composing EPRs");
					e.printStackTrace();
					throw new IllegalStateException();
				}
			}
			
			private void compose(Document doc, Document match) {
				// Prepare replacing fragment (source)
				Element replacingElement = (Element) match.selectSingleNode(getXpathToReplacingFragment());
				// Prepare replaced fragment (destination)
				Element replacedElement = (Element) doc.selectSingleNode(getXpathToReplacedFragment());
				
				if (replacingElement != null && replacedElement != null) {
					replacingElement.detach();
					Element parent = replacedElement.getParent();
					replacedElement.detach();
					// Move node around
					parent.add(replacingElement);
				}
			}
			
		});		
		token.getEnv().setAttribute(outputEprParam, outputEpr.toString());
		return Arc.DEFAULT_ARC;
	}
	
	public MappedResultSetFactory getMappedResultSetFactory() {
		return mappedResultSetFactory;
	}

	@Required
	public void setMappedResultSetFactory(
			MappedResultSetFactory mappedResultSetFactory) {
		this.mappedResultSetFactory = mappedResultSetFactory;
	}

	public ResultSetClientFactory getResultSetClientFactory() {
		return resultSetClientFactory;
	}

	@Required
	public void setResultSetClientFactory(
			ResultSetClientFactory resultSetClientFactory) {
		this.resultSetClientFactory = resultSetClientFactory;
	}

	public String getInputEprParam() {
		return mainEprParam;
	}

	public String getMainEprParam() {
		return mainEprParam;
	}

	public void setMainEprParam(String mainEprParam) {
		this.mainEprParam = mainEprParam;
	}

	public String getAlternateEprParam() {
		return alternateEprParam;
	}

	public void setAlternateEprParam(String alternateEprParam) {
		this.alternateEprParam = alternateEprParam;
	}

	public String getXpathToReplacedFragment() {
		return xpathToReplacedFragment;
	}

	public void setXpathToReplacedFragment(String xpathToReplacedFragment) {
		this.xpathToReplacedFragment = xpathToReplacedFragment;
	}

	public String getXpathToReplacingFragment() {
		return xpathToReplacingFragment;
	}

	public void setXpathToReplacingFragment(String xpathToReplacingFragment) {
		this.xpathToReplacingFragment = xpathToReplacingFragment;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

}
