package eu.dnetlib.msro.eagle.workflows.nodes.composition;

import java.io.StringReader;
import java.util.Iterator;
import java.util.List;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class ComposeEprJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(ComposeEprJobNode.class);

	private String mainEprParam;
	private String alternateEprParam;
	private String xpathToInjectionPoint;
	private String xpathToInjectedElements;
	private String outputEprParam;

	private MappedResultSetFactory mappedResultSetFactory;
	private ResultSetClientFactory resultSetClientFactory;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final W3CEndpointReference inputEpr = new EPRUtils().getEpr(token.getEnv().getAttribute(mainEprParam));
		final Iterator<String> alternateRsClient = resultSetClientFactory.getClient(token.getEnv().getAttribute(alternateEprParam)).iterator();
		final SAXReader reader = new SAXReader();

		final W3CEndpointReference outputEpr = mappedResultSetFactory.createMappedResultSet(inputEpr, new UnaryFunction<String, String>() {

			@Override
			public String evaluate(final String current) {
				try {
					Document main = reader.read(new StringReader(current));
					Document alternate = reader.read(new StringReader(alternateRsClient.next()));
					compose(main, alternate);
					return main.asXML();
				} catch (DocumentException e) {
					log.error("Error composing EPRs");
					e.printStackTrace();
					throw new IllegalStateException();
				}
			}

			private void compose(final Document main, final Document alternate) {
				// Prepare injected fragments (source)
				List<Element> injectedElementList = alternate.selectNodes(getXpathToInjectedElements());
				// Retrieve injection point (destination)
				Element injectionPointElement = (Element) main.selectSingleNode(getXpathToInjectionPoint());

				if (injectedElementList != null && injectionPointElement != null) {
					Element parent = injectionPointElement.getParent();
					// injectionPointElement.detach();
					for (Element injectedElement : injectedElementList) {
						injectedElement.detach();
						// Move node around
						parent.add(injectedElement);
					}
				}
			}
		});

		token.getEnv().setAttribute(outputEprParam, outputEpr.toString());
		return Arc.DEFAULT_ARC;
	}

	public MappedResultSetFactory getMappedResultSetFactory() {
		return mappedResultSetFactory;
	}

	@Required
	public void setMappedResultSetFactory(
			final MappedResultSetFactory mappedResultSetFactory) {
		this.mappedResultSetFactory = mappedResultSetFactory;
	}

	public ResultSetClientFactory getResultSetClientFactory() {
		return resultSetClientFactory;
	}

	@Required
	public void setResultSetClientFactory(
			final ResultSetClientFactory resultSetClientFactory) {
		this.resultSetClientFactory = resultSetClientFactory;
	}

	public String getInputEprParam() {
		return mainEprParam;
	}

	public String getMainEprParam() {
		return mainEprParam;
	}

	public void setMainEprParam(final String mainEprParam) {
		this.mainEprParam = mainEprParam;
	}

	public String getAlternateEprParam() {
		return alternateEprParam;
	}

	public void setAlternateEprParam(final String alternateEprParam) {
		this.alternateEprParam = alternateEprParam;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public String getXpathToInjectionPoint() {
		return xpathToInjectionPoint;
	}

	public void setXpathToInjectionPoint(final String xpathToInjectionPoint) {
		this.xpathToInjectionPoint = xpathToInjectionPoint;
	}

	public String getXpathToInjectedElements() {
		return xpathToInjectedElements;
	}

	public void setXpathToInjectedElements(final String xpathToInjectedElements) {
		this.xpathToInjectedElements = xpathToInjectedElements;
	}

}
