package eu.dnetlib.msro.eagle.workflows.nodes.transform.editions;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;

import javax.xml.transform.stream.StreamSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;

public class EditionXsltUnaryFunction implements UnaryFunction<String, String> {
	private static final Log log = LogFactory.getLog(EditionXsltUnaryFunction.class);
	
	private ApplyXslt xslt;
	private SAXReader reader;
	
	public EditionXsltUnaryFunction(final String xsltPath, Map<String, String> xsltParams) throws IOException {
		
		this.xslt = new ApplyXslt(new StreamSource(new File(xsltPath)), xsltPath, xsltParams);
		this.reader = new SAXReader();
	}
	
	/**
	 * xPath the <metadata> node and applies xslt 2.0 transformation
	 */
	@Override
	public String evaluate(String input) {
		try {
			Document doc = reader.read(new StringReader(input));
			Node result = doc.selectSingleNode("//*[local-name()='metadata']/*");
			String edition = xslt.evaluate(result.asXML());
			result.detach();
			((Element) doc.selectSingleNode("//*[local-name()='metadata']")).add(reader.read(new StringReader(edition)).getRootElement());
			return doc.asXML();
		} catch (DocumentException e) {
			log.error("Problem creating dom4j document from \n" + input, e);
			throw new RuntimeException(e);
		}

	}
}
