<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Retrieve information about current Content Provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="fetchOriginals"/>
	</ARCS>
</NODE>

<NODE name="fetchOriginals" type="FetchMDStoreRecords">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("coll_id")$</PARAM>
		<PARAM required="true" type="string" name="mdFormat" managedBy="system">$params.("coll_format")$</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">orig_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="transformRecords"/>
	</ARCS>
</NODE>

<NODE name="transformRecords" type="Transform">
	<DESCRIPTION>Transform original records in multiple objects compliant with eagle format</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">orig_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">packed_epr</PARAM>
		<PARAM required="true" type="string" name="ruleId" managedBy="user" function="listProfiles('TransformationRuleDSResourceType', '//TITLE')" category="TRANSFORMATION_RULE_ID"  />
	</PARAMETERS>
	<ARCS>
		<ARC to="unpackRecords"/>
	</ARCS>
</NODE>

<NODE name="unpackRecords" type="Unpack">
	<DESCRIPTION>Unpack objects</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">packed_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">eagle_epr</PARAM>
		<PARAM required="true" type="string" name="xpath" managedBy="user">//*[local-name()='record']</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="trismegistosInjection"/>
	</ARCS>
</NODE>

<NODE name="trismegistosInjection" type="TrismegistosInject">
	<DESCRIPTION>Unpack objects</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">eagle_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">injected_epr</PARAM>
		<PARAM required="true" type="string" name="tmIdListPath" managedBy="user">/var/lib/eagle/content/Trismegistos/tmid.xml</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="storeRecords"/>
	</ARCS>
</NODE>

<NODE name="storeRecords" type="StoreMDStoreRecords">
	<DESCRIPTION>Store records into mdstore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("tran_id")$</PARAM>
		<PARAM required="true" type="string" name="storingType" managedBy="system">REFRESH</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">injected_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="UPDATE_INFO"/>
	</ARCS>
</NODE>

 <NODE name="UPDATE_INFO" type="MDStoreToApiExtraField">
	<DESCRIPTION>Update datasouce API extra fields</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("tran_id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="true" type="string" name="extraFieldForTotal" managedBy="system">last_aggregation_total</PARAM>
		<PARAM required="true" type="string" name="extraFieldForDate" managedBy="system">last_aggregation_date</PARAM>
		<PARAM required="true" type="string" name="extraFieldForMdId" managedBy="system">last_aggregation_mdId</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>