/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.eagle.workflows.nodes.composition;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class ComposeEprJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(ComposeEprJobNode.class);
    private String mainEprParam;
    private String alternateEprParam;
    private String xpathToInjectionPoint;
    private String xpathToInjectedElements;
    private String outputEprParam;
    private MappedResultSetFactory mappedResultSetFactory;
    private ResultSetClientFactory resultSetClientFactory;

    protected String execute(NodeToken token) throws Exception {
        W3CEndpointReference inputEpr = new EPRUtils().getEpr(token.getEnv().getAttribute(this.mainEprParam));
        final Iterator alternateRsClient = this.resultSetClientFactory.getClient(token.getEnv().getAttribute(this.alternateEprParam)).iterator();
        final SAXReader reader = new SAXReader();
        W3CEndpointReference outputEpr = this.mappedResultSetFactory.createMappedResultSet(inputEpr, (UnaryFunction)new UnaryFunction<String, String>(){

            public String evaluate(String current) {
                try {
                    Document main = reader.read((Reader)new StringReader(current));
                    Document alternate = reader.read((Reader)new StringReader((String)alternateRsClient.next()));
                    this.compose(main, alternate);
                    return main.asXML();
                }
                catch (DocumentException e) {
                    log.error((Object)"Error composing EPRs");
                    e.printStackTrace();
                    throw new IllegalStateException();
                }
            }

            private void compose(Document main, Document alternate) {
                List injectedElementList = alternate.selectNodes(ComposeEprJobNode.this.getXpathToInjectedElements());
                Element injectionPointElement = (Element)main.selectSingleNode(ComposeEprJobNode.this.getXpathToInjectionPoint());
                if (injectedElementList != null && injectionPointElement != null) {
                    Element parent = injectionPointElement.getParent();
                    for (Element injectedElement : injectedElementList) {
                        injectedElement.detach();
                        parent.add(injectedElement);
                    }
                }
            }
        });
        token.getEnv().setAttribute(this.outputEprParam, outputEpr.toString());
        return Arc.DEFAULT_ARC;
    }

    public MappedResultSetFactory getMappedResultSetFactory() {
        return this.mappedResultSetFactory;
    }

    @Required
    public void setMappedResultSetFactory(MappedResultSetFactory mappedResultSetFactory) {
        this.mappedResultSetFactory = mappedResultSetFactory;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public String getInputEprParam() {
        return this.mainEprParam;
    }

    public String getMainEprParam() {
        return this.mainEprParam;
    }

    public void setMainEprParam(String mainEprParam) {
        this.mainEprParam = mainEprParam;
    }

    public String getAlternateEprParam() {
        return this.alternateEprParam;
    }

    public void setAlternateEprParam(String alternateEprParam) {
        this.alternateEprParam = alternateEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getXpathToInjectionPoint() {
        return this.xpathToInjectionPoint;
    }

    public void setXpathToInjectionPoint(String xpathToInjectionPoint) {
        this.xpathToInjectionPoint = xpathToInjectionPoint;
    }

    public String getXpathToInjectedElements() {
        return this.xpathToInjectedElements;
    }

    public void setXpathToInjectedElements(String xpathToInjectedElements) {
        this.xpathToInjectedElements = xpathToInjectedElements;
    }
}

