/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.eagle.workflows.nodes.transform.tmid;

import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.FileSystemResource;

public class TrismegistosInjectionUnaryFunction
implements UnaryFunction<String, String> {
    private SAXReader reader = new SAXReader();
    private static Map<String, List<String>> tmIdToLocalIdsMap;
    private static Map<String, String> localIdToTmIdMap;

    public TrismegistosInjectionUnaryFunction(String tmIdListPath) throws XMLStreamException, IOException {
        tmIdToLocalIdsMap = new HashMap<String, List<String>>();
        localIdToTmIdMap = new HashMap<String, String>();
        FileSystemResource tmIds = new FileSystemResource(tmIdListPath);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader reader = factory.createXMLStreamReader(tmIds.getInputStream());
        boolean isSafeToGetNextXmlElement = true;
        while (isSafeToGetNextXmlElement) {
            if (reader.getEventType() == 1 && "tmid".equals(reader.getLocalName())) {
                this.parseTmEvent(reader);
            }
            if (reader.hasNext()) {
                reader.next();
                continue;
            }
            isSafeToGetNextXmlElement = false;
            break;
        }
    }

    private void parseTmEvent(XMLStreamReader reader) throws XMLStreamException {
        String tmId = reader.getAttributeValue(null, "id");
        ArrayList<String> localIds = new ArrayList<String>();
        boolean isSafeToGetNextXmlElement = true;
        while (isSafeToGetNextXmlElement && reader.getEventType() != 2) {
            if (reader.getEventType() == 1 && "link".equals(reader.getLocalName())) {
                String localId = this.parseLinkEvent(reader);
                localIdToTmIdMap.put(localId, tmId);
                localIds.add(localId);
            }
            if (reader.hasNext()) {
                reader.next();
                continue;
            }
            isSafeToGetNextXmlElement = false;
            break;
        }
        tmIdToLocalIdsMap.put(tmId, localIds);
    }

    private String parseLinkEvent(XMLStreamReader reader) throws XMLStreamException {
        String cp = reader.getAttributeValue(null, "cp");
        String val = "";
        boolean isSafeToGetNextXmlElement = true;
        while (isSafeToGetNextXmlElement && reader.getEventType() != 2) {
            if (reader.getEventType() == 4) {
                val = reader.getText();
            }
            if (reader.hasNext()) {
                reader.next();
                continue;
            }
            isSafeToGetNextXmlElement = false;
            break;
        }
        return cp + "::" + val;
    }

    public String evaluate(String inputXml) {
        try {
            Document doc = this.reader.read((Reader)new StringReader(inputXml));
            Node entityType = doc.selectSingleNode("//*[local-name()='entityType']");
            if ("artifact".equals(entityType.getText())) {
                Node recordSourceInfo = doc.selectSingleNode("//*[local-name()='eagleObject']/*[local-name()='recordSourceInfo']");
                String localId = recordSourceInfo.selectSingleNode("@providerAcronym").getText() + "::" + recordSourceInfo.selectSingleNode("./text()").getText();
                String tmId = localIdToTmIdMap.get(localId);
                if (tmId != null) {
                    List<String> alternateIds = tmIdToLocalIdsMap.get(tmId);
                    Element inscription = (Element)doc.selectSingleNode("//*[local-name()='inscription']");
                    Element injectedHasTmId = this.prepareInjectedElement(tmId, alternateIds, localId);
                    this.replaceElement(inscription, (Element)inscription.selectSingleNode("hasTmId"), injectedHasTmId);
                    return doc.asXML();
                }
                return inputXml;
            }
            if ("visual".equals(entityType.getText()) || "documental".equals(entityType.getText())) {
                Node recordSourceInfo = doc.selectSingleNode("//*[local-name()='hasArtifact']/*[local-name()='recordSourceInfo']");
                String localId = recordSourceInfo.selectSingleNode("@providerAcronym").getText() + "::" + recordSourceInfo.selectSingleNode("./text()").getText();
                String tmId = localIdToTmIdMap.get(localId);
                if (tmId != null) {
                    List<String> alternateIds = tmIdToLocalIdsMap.get(tmId);
                    Element inscription = (Element)doc.selectSingleNode("//*[local-name()='hasArtifact']");
                    Element injectedHasTmId = this.prepareInjectedElement(tmId, alternateIds, localId);
                    this.replaceElement(inscription, (Element)inscription.selectSingleNode("hasTmId"), injectedHasTmId);
                    return doc.asXML();
                }
                return inputXml;
            }
        }
        catch (DocumentException e) {
            throw new IllegalStateException("Problems with Trismegistos injection", e);
        }
        return inputXml;
    }

    private Element prepareInjectedElement(String tmId, List<String> alternateIds, String localId) {
        Document fragment = DocumentHelper.createDocument();
        Element hasTmId = fragment.addElement("hasTmId");
        hasTmId.addElement("tmId").addText(tmId);
        for (String alternateId : alternateIds) {
            if (localId.equals(alternateId)) continue;
            String[] tokens = alternateId.split("::");
            hasTmId.addElement("alternateId").addAttribute("providerAcronym", tokens[0]).addAttribute("localId", tokens[1]).setText(tokens[0] + "::" + Hashing.md5((String)tokens[1]) + "::artifact");
        }
        return (Element)fragment.selectSingleNode("hasTmId");
    }

    private void replaceElement(Element parent, Element oldElement, Element newElement) {
        List parentContent = parent.content();
        int index = parentContent.indexOf(oldElement);
        parentContent.set(index, newElement);
    }
}

