/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.provision.pdf;

import eu.dnetlib.functionality.index.client.IndexClient;
import eu.dnetlib.functionality.index.client.IndexClientException;
import eu.dnetlib.functionality.index.client.IndexClientFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class PdfMaterializerController {
    private static final int MARGIN = 72;
    private static final float LEADING_SPACE = 1.5f;
    private static final int FONT_SIZE = 12;
    private static final Log log = LogFactory.getLog(PdfMaterializerController.class);
    @Resource
    private IndexClientFactory indexClientFactory;
    @Value(value="${eagle.provision.pdf.index.format}")
    private String indexFormat;
    @Value(value="${eagle.provision.pdf.index.layout}")
    private String indexLayout;
    @Value(value="${eagle.provision.pdf.index.interpretation}")
    private String indexInterpretation;
    @Value(value="${eagle.provision.pdf.index.id.field}")
    private String indexIdField;
    @Value(value="${eagle.provision.pdf.index.text.xpath}")
    private String textXpath;
    private ClassPathResource trueType = new ClassPathResource("/eu/dnetlib/data/provision/pdf/lmroman10-regular.ttf");

    @RequestMapping(value={"/pdfs/{id}"})
    public void generatePdfFromId(HttpServletRequest request, HttpServletResponse response, @PathVariable String id) throws IOException, COSVisitorException, IndexClientException, DocumentException {
        log.info((Object)"Materializing pdf");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getTextToPrint(id));
        this.writeText(arrayList, response.getOutputStream());
    }

    public void writeText(List<String> arrayList, ServletOutputStream outputStream) throws IOException, COSVisitorException {
        PDDocument document = new PDDocument();
        PDPage page = new PDPage();
        PDTrueTypeFont font = PDTrueTypeFont.loadTTF((PDDocument)document, (InputStream)this.trueType.getInputStream());
        int positionX = 30;
        int positionY = 750;
        document.addPage(page);
        PDPageContentStream contentStream = new PDPageContentStream(document, page);
        for (int i = 0; i < arrayList.size(); ++i) {
            String text = arrayList.get(i);
            String[] tmpText = this.splitString(text);
            for (int k = 0; k < tmpText.length; ++k) {
                contentStream.beginText();
                contentStream.setFont((PDFont)font, 12.0f);
                contentStream.moveTextPositionByAmount((float)positionX, (float)positionY);
                contentStream.drawString(tmpText[k]);
                contentStream.endText();
                positionY -= 20;
            }
            contentStream.setLineWidth(0.25f);
        }
        contentStream.close();
        document.save((OutputStream)outputStream);
        document.close();
    }

    public String[] splitString(String text) {
        int linebreaks = text.length() / 40;
        String[] newText = new String[linebreaks + 1];
        String tmpText = text;
        String[] parts = tmpText.split(" ");
        StringBuffer[] stringBuffer = new StringBuffer[linebreaks + 1];
        int i = 0;
        int totalTextLength = 0;
        for (int k = 0; k < linebreaks + 1; ++k) {
            stringBuffer[k] = new StringBuffer();
            while (i < parts.length && (totalTextLength += parts[i].length()) <= 40) {
                stringBuffer[k].append(parts[i]);
                stringBuffer[k].append(" ");
                ++i;
            }
            totalTextLength = 0;
            newText[k] = stringBuffer[k].toString();
        }
        return newText;
    }

    private String getTextToPrint(String id) throws IndexClientException, DocumentException {
        IndexClient indexClient = this.indexClientFactory.getClient(this.indexFormat, this.indexLayout, this.indexInterpretation);
        List results = indexClient.lookup(this.indexIdField + "=" + id, null, 0, 10).getRecords();
        if (results.size() != 1) {
            throw new IndexClientException("The query was supposed to return EXACTLY ONE record (not 0, nor 2 or more)");
        }
        String record = (String)results.get(0);
        SAXReader reader = new SAXReader();
        return reader.read((Reader)new StringReader(record)).valueOf(this.textXpath);
    }

    @ExceptionHandler(value={IndexClientException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public String notFoundHandler(Exception e) {
        e.printStackTrace();
        return e.getMessage();
    }

    @ExceptionHandler(value={DocumentException.class, IOException.class, COSVisitorException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public String internaErrorHandler(Exception e) {
        e.printStackTrace();
        return e.getMessage();
    }

    public String getIndexFormat() {
        return this.indexFormat;
    }

    public void setIndexFormat(String indexFormat) {
        this.indexFormat = indexFormat;
    }

    public String getIndexLayout() {
        return this.indexLayout;
    }

    public void setIndexLayout(String indexLayout) {
        this.indexLayout = indexLayout;
    }

    public String getIndexInterpretation() {
        return this.indexInterpretation;
    }

    public void setIndexInterpretation(String indexInterpretation) {
        this.indexInterpretation = indexInterpretation;
    }

    public String getIndexIdField() {
        return this.indexIdField;
    }

    public void setIndexIdField(String indexIdField) {
        this.indexIdField = indexIdField;
    }

    public String getTextXpath() {
        return this.textXpath;
    }

    public void setTextXpath(String textXpath) {
        this.textXpath = textXpath;
    }
}

