package eu.dnetlib.data.download.plugins;

import java.util.ArrayList;
import java.util.List;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;

import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;

public class EagleDownloadPlugin implements DownloadPlugin {

	@Override
	public DownloadItem retrieveUrl(final DownloadItem item) {
		String url = item.getUrl();

		if (url == null || url.trim().length() == 0) { return null; }
		@SuppressWarnings("unchecked")
		List<String> urls = new Gson().fromJson(url, ArrayList.class);
		if (urls == null || urls.size() == 0) {
			item.setOriginalUrl(null);
			item.setUrl(null);
			item.setFileName(item.getIdItemMetadata());
			return item;
		}
		item.setOriginalUrl(urls.get(0));
		item.setUrl(urls.get(0));
		item.setFileName(item.getIdItemMetadata());
		return item;
	}

	@Override
	public Iterable<DownloadItem> retireveUrls(final Iterable<DownloadItem> items) {

		return Iterables.transform(items, new Function<DownloadItem, DownloadItem>() {

			@Override
			public DownloadItem apply(final DownloadItem input) {
				return retrieveUrl(input);
			}
		});
	}

	@Override
	public String getPluginName() {
		return "EagleDownloadPlugin";
	}

	@Override
	public void setBasePath(final String arg0) {
		// TODO Auto-generated method stub
	}

}
