/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.eagle.workflows.nodes.transform.editions;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.msro.eagle.workflows.nodes.transform.editions.EditionXsltUnaryFunction;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

public class ApplyEditionXsltJobNode
extends SimpleJobNode {
    private String inputEprParam;
    private String outputEprParam;
    private String xsltPath;
    private MappedResultSetFactory mappedResultSetFactory;
    private final Map<String, String> xsltParams = new HashMap<String, String>();

    protected String execute(NodeToken token) throws Exception {
        String inputEpr = token.getEnv().getAttribute(this.inputEprParam);
        if (inputEpr == null || inputEpr.isEmpty()) {
            throw new MSROException("InputEprParam (" + this.inputEprParam + ") not found in ENV");
        }
        for (String name : token.getFullEnv().getAttributeNames()) {
            this.xsltParams.put(name, token.getFullEnv().getAttribute(name));
        }
        for (String name : token.getEnv().getAttributeNames()) {
            this.xsltParams.put(name, token.getEnv().getAttribute(name));
        }
        this.xsltParams.putAll(this.parseJsonParameters(token));
        W3CEndpointReference epr = this.mappedResultSetFactory.createMappedResultSet(new EPRUtils().getEpr(inputEpr), (UnaryFunction)new EditionXsltUnaryFunction(this.xsltPath, this.xsltParams));
        token.getEnv().setAttribute(this.outputEprParam, epr.toString());
        return Arc.DEFAULT_ARC;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getXsltPath() {
        return this.xsltPath;
    }

    public void setXsltPath(String xsltPath) {
        this.xsltPath = xsltPath;
    }

    public MappedResultSetFactory getMappedResultSetFactory() {
        return this.mappedResultSetFactory;
    }

    public void setMappedResultSetFactory(MappedResultSetFactory mappedResultSetFactory) {
        this.mappedResultSetFactory = mappedResultSetFactory;
    }
}

