package eu.dnetlib.data.collector.plugins.mediawiki;

import java.util.Iterator;

import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;

public class MediawikiCollectorPlugin extends AbstractCollectorPlugin {

	@Override
	public Iterable<String> collect(final InterfaceDescriptor interfaceDescriptor, final String fromDate, final String untilDate)
			throws CollectorServiceException {
		final String baseUrl = interfaceDescriptor.getBaseUrl();
		final String apnamespace = interfaceDescriptor.getParams().get("apnamespace");

		if (baseUrl == null || baseUrl.isEmpty()) { throw new CollectorServiceException("Param 'baseurl' is null or empty"); }

		if (apnamespace == null || baseUrl.isEmpty()) { throw new CollectorServiceException("Param 'apnamespace' is null or empty"); }

		return new Iterable<String>() {

			@Override
			public Iterator<String> iterator() {
				return new MediawikiIterator(baseUrl, apnamespace);
			}
		};
	}

}
