package eu.dnetlib.data.provision.epidoc;

import java.io.IOException;
import java.io.StringReader;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import eu.dnetlib.data.mdstore.DocumentNotFoundException;
import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;

@Controller
public class EpidocRecordProvider {

	private static final Log log = LogFactory.getLog(EpidocRecordProvider.class);

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Autowired
	private MdIdResolver resolver;

	@RequestMapping("/epidoc/{objIdentfier}")
	public void provideEpidoc(final HttpServletRequest request, final HttpServletResponse response, @PathVariable final String objIdentfier)
			throws IOException, DocumentNotFoundException, MDStoreServiceException, DocumentException, ISLookUpException {
		log.info("Retrieve original Epidoc record id = " + objIdentfier);

		String repoAcronym = objIdentfier.split("::")[0];

		String record = serviceLocator.getService(MDStoreService.class).deliverRecord(resolver.resolveMdId(repoAcronym), objIdentfier);

		Document doc = new SAXReader().read(new StringReader(record));
		response.setHeader("Content-Type", "text/xml; charset=UTF-8");
		response.getWriter().write(doc.selectSingleNode("//oai:metadata/*").asXML());
	}

}
