package eu.dnetlib.data.provision;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.dom4j.DocumentException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class FakeImageProvider {

	private static final Log log = LogFactory.getLog(FakeImageProvider.class);

	@RequestMapping("/img/{id}.png")
	public void generateImage(final HttpServletRequest request, final HttpServletResponse response, @PathVariable final String id) throws IOException,
	COSVisitorException, DocumentException {
		log.debug("Generate fake image");

		response.setContentType("image/png");

		ClassPathResource image = new ClassPathResource("/eu/dnetlib/data/provision/eagle_logo.png");
		BufferedImage bi = ImageIO.read(image.getInputStream());
		OutputStream out = response.getOutputStream();
		ImageIO.write(bi, "png", out);
		out.close();

	}
}
