package eu.dnetlib.msro.eagle.workflows.nodes.backlink.translations;

import java.io.IOException;

import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;

public class HasTranslationFragment {

	static public String generateFragment(final TranslationInfo translationInfo) {
		String fragmentTemplate;
		try {
			fragmentTemplate =
					IOUtils.toString(HasTranslationFragment.class
							.getResourceAsStream("/eu/dnetlib/msro/eagle/workflows/backlink/translations/hasTranslation.xml.st"));
			StringTemplate st = new StringTemplate(fragmentTemplate);
			st.setAttribute("dnetResourceIdentifier", translationInfo.getDnetResourceIdentifier());
			st.setAttribute("providerName", translationInfo.getProviderName());
			st.setAttribute("providerAcronym", translationInfo.getProviderAcronym());
			st.setAttribute("landingPage", translationInfo.getLandingPage());
			st.setAttribute("localId", translationInfo.getLocalId());
			st.setAttribute("text", translationInfo.getText());
			st.setAttribute("lang", translationInfo.getLang());
			return st.toString();
		} catch (IOException e) {
			throw new RuntimeException("HasTranslation template not found!", e);
		}

	}

}
