/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.eagle.workflows.nodes.backlink.translations;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.msro.eagle.workflows.nodes.backlink.translations.TranslationBacklinkUnaryFunction;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.Iterator;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class TranslationBacklinkJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(TranslationBacklinkJobNode.class);
    private String inputEprParam;
    private String outputEprParam;
    private MappedResultSetFactory mappedResultSetFactory;
    private ResultSetClientFactory resultSetClientFactory;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    protected String execute(NodeToken token) throws Exception {
        W3CEndpointReference inputEpr = new EPRUtils().getEpr(token.getEnv().getAttribute(this.inputEprParam));
        String xQueryTranslation = "for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x//WORKFLOW_NAME = 'index' and $x//PARAM[./@name = 'providerName']/text() = 'EAGLE MediaWiki' return $x//PARAM[./@name='mdId']/text()";
        String translationStoreId = (String)((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xQueryTranslation).get(0);
        W3CEndpointReference translationsEpr = ((MDStoreService)this.serviceLocator.getService(MDStoreService.class)).deliverMDRecords(translationStoreId, "", "", "");
        Iterator translationIterator = this.resultSetClientFactory.getClient(translationsEpr).iterator();
        W3CEndpointReference epr = this.mappedResultSetFactory.createMappedResultSet(inputEpr, (UnaryFunction)new TranslationBacklinkUnaryFunction(translationIterator));
        token.getEnv().setAttribute(this.outputEprParam, epr.toString());
        return Arc.DEFAULT_ARC;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public MappedResultSetFactory getMappedResultSetFactory() {
        return this.mappedResultSetFactory;
    }

    @Required
    public void setMappedResultSetFactory(MappedResultSetFactory mappedResultSetFactory) {
        this.mappedResultSetFactory = mappedResultSetFactory;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }
}

