<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output omit-xml-declaration="yes" indent="yes"/>

    <xsl:template match="/FIELDS">

        <xsl:param name="textFieldType" select="string('text_ancient')"/>
        <xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'"/>
        <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>

        <!--
        D-Net index schema template

        CHANGELOG

        0.1 : first release
        0.2 : added preserveOriginal="1" for text field type in the index analyzer and catenateWords="1" for the query analyzer
        0.3 : changed language for SnowballPorterFilterFactory to language="German2" (index/query) in the text field type
        0.4 : added solr.ASCIIFoldingFilterFactory filter (index/query) in the text field type
        0.5 : added long_keyword field type, to be used for objIdentifiers
        0.6 : added field types for spellchecking
        0.7 : added parameter for text field type
        0.8 : added field _version_, needed by Solr 4.0.0 for the transaction log
        0.9   : added type: text_en_splitting
        0.91  : added type: ngramtext
        0.92  : added schema optimizations, removing unnecessary stored fields
        0.93  : added attribute preserveOriginal="1" to fieldtype ngramtext (query analysis) to improve matches
        0.94  : updated and simplified ngramtext fieldtype
        0.95  : update to solr 4.4, removed attribute "compress" from field definition, ngramfield doesn't support NGramFilterFactory anymore
        0.96  : update to solr 4.9
         -->
        <schema name="dnet" version="0.96">

            <types>

                <!-- The StrField type is not analyzed, but indexed/stored verbatim.
                   It supports doc values but in that case the field needs to be
                   single-valued and either required or have a default value.
                  -->
                <fieldType name="string" class="solr.StrField" sortMissingLast="true"/>

                <!-- boolean type: "true" or "false" -->
                <fieldType name="boolean" class="solr.BoolField" sortMissingLast="true"/>

                <!-- sortMissingLast and sortMissingFirst attributes are optional attributes are
                     currently supported on types that are sorted internally as strings
                     and on numeric types.
                     This includes "string","boolean", and, as of 3.5 (and 4.x),
                     int, float, long, date, double, including the "Trie" variants.
                   - If sortMissingLast="true", then a sort on this field will cause documents
                     without the field to come after documents with the field,
                     regardless of the requested sort order (asc or desc).
                   - If sortMissingFirst="true", then a sort on this field will cause documents
                     without the field to come before documents with the field,
                     regardless of the requested sort order.
                   - If sortMissingLast="false" and sortMissingFirst="false" (the default),
                     then default lucene sorting will be used which places docs without the
                     field first in an ascending sort and last in a descending sort.
                -->

                <!--
                  Default numeric field types. For faster range queries, consider the tint/tfloat/tlong/tdouble types.

                  These fields support doc values, but they require the field to be
                  single-valued and either be required or have a default value.
                -->
                <fieldType name="int" class="solr.TrieIntField" precisionStep="0" positionIncrementGap="0"/>
                <fieldType name="float" class="solr.TrieFloatField" precisionStep="0" positionIncrementGap="0"/>
                <fieldType name="long" class="solr.TrieLongField" precisionStep="0" positionIncrementGap="0"/>
                <fieldType name="double" class="solr.TrieDoubleField" precisionStep="0" positionIncrementGap="0"/>

                <!--
                 Numeric field types that index each value at various levels of precision
                 to accelerate range queries when the number of values between the range
                 endpoints is large. See the javadoc for NumericRangeQuery for internal
                 implementation details.

                 Smaller precisionStep values (specified in bits) will lead to more tokens
                 indexed per value, slightly larger index size, and faster range queries.
                 A precisionStep of 0 disables indexing at different precision levels.
                -->
                <fieldType name="tint" class="solr.TrieIntField" precisionStep="8" positionIncrementGap="0"/>
                <fieldType name="tfloat" class="solr.TrieFloatField" precisionStep="8" positionIncrementGap="0"/>
                <fieldType name="tlong" class="solr.TrieLongField" precisionStep="8" positionIncrementGap="0"/>
                <fieldType name="tdouble" class="solr.TrieDoubleField" precisionStep="8" positionIncrementGap="0"/>

                <!-- The format for this date field is of the form 1995-12-31T23:59:59Z, and
                     is a more restricted form of the canonical representation of dateTime
                     http://www.w3.org/TR/xmlschema-2/#dateTime
                     The trailing "Z" designates UTC time and is mandatory.
                     Optional fractional seconds are allowed: 1995-12-31T23:59:59.999Z
                     All other components are mandatory.

                     Expressions can also be used to denote calculations that should be
                     performed relative to "NOW" to determine the value, ie...

                           NOW/HOUR
                              ... Round to the start of the current hour
                           NOW-1DAY
                              ... Exactly 1 day prior to now
                           NOW/DAY+6MONTHS+3DAYS
                              ... 6 months and 3 days in the future from the start of
                                  the current day

                     Consult the DateField javadocs for more information.

                     Note: For faster range queries, consider the tdate type
                  -->
                <fieldType name="date" class="solr.TrieDateField" precisionStep="0" positionIncrementGap="0"/>

                <!-- A Trie based date field for faster date range queries and date faceting. -->
                <fieldType name="tdate" class="solr.TrieDateField" precisionStep="6" positionIncrementGap="0"/>

                <!--
                  Note:
                  These should only be used for compatibility with existing indexes (created with older Solr versions)
                  or if "sortMissingFirst" or "sortMissingLast" functionality is needed. Use Trie based fields instead.

                  Numeric field types that manipulate the value into
                  a string value that isn't human-readable in its internal form,
                  but with a lexicographic ordering the same as the numeric ordering,
                  so that range queries work correctly.
                -->
                <fieldType name="sint" class="solr.SortableIntField" sortMissingLast="true" omitNorms="true"/>
                <fieldType name="slong" class="solr.SortableLongField" sortMissingLast="true" omitNorms="true"/>
                <fieldType name="sfloat" class="solr.SortableFloatField" sortMissingLast="true" omitNorms="true"/>
                <fieldType name="sdouble" class="solr.SortableDoubleField" sortMissingLast="true" omitNorms="true"/>

                <!-- A text field that uses WordDelimiterFilter to enable splitting and matching of
                    words on case-change, alpha numeric boundaries, and non-alphanumeric chars,
                    so that a query of "wifi" or "wi fi" could match a document containing "Wi-Fi".
                    Synonyms and stopwords are customized by external files, and stemming is enabled.
                    -->
                <fieldType name="text_common" class="solr.TextField" positionIncrementGap="100">
                    <analyzer type="index">
                        <tokenizer class="solr.WhitespaceTokenizerFactory"/>
                        <filter class="solr.StopFilterFactory" ignoreCase="true"
                                words="stopwords.txt" enablePositionIncrements="true"/>
                        <filter class="solr.WordDelimiterFilterFactory"
                                preserveOriginal="1" generateWordParts="1"
                                generateNumberParts="1" catenateWords="1"
                                catenateNumbers="1" catenateAll="0"/>
                        <filter class="solr.LowerCaseFilterFactory"/>
                        <filter class="solr.ASCIIFoldingFilterFactory"/>
                    </analyzer>
                    <analyzer type="query">
                        <tokenizer class="solr.WhitespaceTokenizerFactory"/>
                        <filter class="solr.SynonymFilterFactory" synonyms="synonyms.txt" ignoreCase="true"
                                expand="true"/>
                        <filter class="solr.StopFilterFactory" ignoreCase="true"
                                words="stopwords.txt" enablePositionIncrements="true"/>
                        <filter class="solr.WordDelimiterFilterFactory"
                                preserveOriginal="1" generateWordParts="1"
                                generateNumberParts="1" catenateWords="0"
                                catenateNumbers="0" catenateAll="0"/>
                        <filter class="solr.LowerCaseFilterFactory"/>
                        <filter class="solr.ASCIIFoldingFilterFactory"/>
                    </analyzer>
                </fieldType>

                <!-- A text field with defaults appropriate for English, plus
                 aggressive word-splitting and autophrase features enabled.
                 This field is just like text_en, except it adds
                 WordDelimiterFilter to enable splitting and matching of
                 words on case-change, alpha numeric boundaries, and
                 non-alphanumeric chars.  This means certain compound word
                 cases will work, for example query "wi fi" will match
                 document "WiFi" or "wi-fi".
                    -->
                <fieldType name="text_en_splitting" class="solr.TextField" positionIncrementGap="100"
                           autoGeneratePhraseQueries="true">
                    <analyzer type="index">
                        <tokenizer class="solr.WhitespaceTokenizerFactory"/>
                        <!-- in this example, we will only use synonyms at query time
                        <filter class="solr.SynonymFilterFactory" synonyms="index_synonyms.txt" ignoreCase="true" expand="false"/>
                        -->
                        <!-- Case insensitive stop word removal.
                        -->
                        <filter class="solr.StopFilterFactory"
                                ignoreCase="true"
                                words="stopwords_en.txt"
                        />
                        <filter class="solr.WordDelimiterFilterFactory" generateWordParts="1" generateNumberParts="1"
                                catenateWords="1" catenateNumbers="1" catenateAll="0" splitOnCaseChange="1"/>
                        <filter class="solr.LowerCaseFilterFactory"/>
                        <filter class="solr.KeywordMarkerFilterFactory" protected="protwords.txt"/>
                        <filter class="solr.PorterStemFilterFactory"/>
                    </analyzer>
                    <analyzer type="query">
                        <tokenizer class="solr.WhitespaceTokenizerFactory"/>
                        <filter class="solr.SynonymFilterFactory" synonyms="synonyms.txt" ignoreCase="true"
                                expand="true"/>
                        <filter class="solr.StopFilterFactory"
                                ignoreCase="true"
                                words="stopwords_en.txt"
                        />
                        <filter class="solr.WordDelimiterFilterFactory" generateWordParts="1" generateNumberParts="1"
                                catenateWords="0" catenateNumbers="0" catenateAll="0" splitOnCaseChange="1"/>
                        <filter class="solr.LowerCaseFilterFactory"/>
                        <filter class="solr.KeywordMarkerFilterFactory" protected="protwords.txt"/>
                        <filter class="solr.PorterStemFilterFactory"/>
                    </analyzer>
                </fieldType>

                <fieldType name="ngramtext" class="solr.TextField" omitNorms="true">
                    <analyzer type="index">
                        <tokenizer class="solr.KeywordTokenizerFactory"/>
                        <filter class="solr.LowerCaseFilterFactory"/>
                        <filter class="solr.NGramFilterFactory" minGramSize="3" maxGramSize="25"/>
                        <filter class="solr.TrimFilterFactory"/>
                        <filter class="solr.RemoveDuplicatesTokenFilterFactory"/>
                    </analyzer>
                    <analyzer type="query">
                        <tokenizer class="solr.KeywordTokenizerFactory"/>
                        <filter class="solr.LowerCaseFilterFactory"/>
                    </analyzer>
                </fieldType>

                <fieldType name="text_german" class="solr.TextField" positionIncrementGap="100">
                    <analyzer type="index">
                        <tokenizer class="solr.WhitespaceTokenizerFactory"/>
                        <filter class="solr.StopFilterFactory" ignoreCase="true"
                                words="stopwords.txt" enablePositionIncrements="true"/>
                        <filter class="solr.WordDelimiterFilterFactory"
                                preserveOriginal="1" generateWordParts="1"
                                generateNumberParts="1" catenateWords="1"
                                catenateNumbers="1" catenateAll="0"
                                splitOnCaseChange="1"/>
                        <filter class="solr.LowerCaseFilterFactory"/>
                        <filter class="solr.SnowballPorterFilterFactory" language="German2" protected="protwords.txt"/>
                        <filter class="solr.ASCIIFoldingFilterFactory"/>
                    </analyzer>
                    <analyzer type="query">
                        <tokenizer class="solr.WhitespaceTokenizerFactory"/>
                        <filter class="solr.SynonymFilterFactory" synonyms="synonyms.txt" ignoreCase="true"
                                expand="true"/>
                        <filter class="solr.StopFilterFactory" ignoreCase="true"
                                words="stopwords.txt" enablePositionIncrements="true"/>
                        <filter class="solr.WordDelimiterFilterFactory"
                                generateWordParts="0" generateNumberParts="1"
                                catenateWords="1" catenateNumbers="0"
                                catenateAll="0" splitOnCaseChange="1"/>
                        <filter class="solr.LowerCaseFilterFactory"/>
                        <filter class="solr.SnowballPorterFilterFactory" language="German2" protected="protwords.txt"/>
                        <filter class="solr.ASCIIFoldingFilterFactory"/>
                    </analyzer>
                </fieldType>

                <fieldType name="text_ancient" class="solr.TextField" positionIncrementGap="100">
                    <analyzer type="index">
                        <!-- <charFilter class="solr.MappingCharFilterFactory" mapping="mapping-FoldToASCII.txt"/> -->
                        <tokenizer class="solr.WhitespaceTokenizerFactory"/>
                        <filter class="solr.ICUFoldingFilterFactory"/>
                        <!-- <filter class="solr.StopFilterFactory" ignoreCase="true" words="stopwords.txt" /> -->
                        <filter class="solr.WordDelimiterFilterFactory" preserveOriginal="1" generateWordParts="1"
                                generateNumberParts="1" catenateWords="1" catenateNumbers="1" catenateAll="0"/>
                        <!-- <filter class="solr.LowerCaseFilterFactory"/> -->
                        <!-- <filter class="solr.ASCIIFoldingFilterFactory"/> -->
                    </analyzer>
                    <analyzer type="query">
                        <!-- <charFilter class="solr.MappingCharFilterFactory" mapping="mapping-FoldToASCII.txt"/> -->
                        <tokenizer class="solr.WhitespaceTokenizerFactory"/>
                        <filter class="solr.ICUFoldingFilterFactory"/>
                        <!-- <filter class="solr.SynonymFilterFactory" synonyms="synonyms.txt" ignoreCase="true" expand="true"/> -->
                        <!-- <filter class="solr.StopFilterFactory" ignoreCase="true" words="stopwords.txt" /> -->
                        <filter class="solr.WordDelimiterFilterFactory" preserveOriginal="1" generateWordParts="1"
                                generateNumberParts="1" catenateWords="0" catenateNumbers="0" catenateAll="0"/>
                        <!-- <filter class="solr.LowerCaseFilterFactory"/> -->
                        <!-- <filter class="solr.ASCIIFoldingFilterFactory"/> -->
                    </analyzer>
                </fieldType>

                <!-- A general unstemmed text field that indexes tokens normally and also
                     reversed (via ReversedWildcardFilterFactory), to enable more efficient
                 leading wildcard queries. -->
                <fieldType name="text_rev" class="solr.TextField" positionIncrementGap="100">
                    <analyzer type="index">
                        <tokenizer class="solr.WhitespaceTokenizerFactory"/>
                        <filter class="solr.StopFilterFactory" ignoreCase="true"
                                words="stopwords.txt" enablePositionIncrements="true"/>
                        <filter class="solr.WordDelimiterFilterFactory"
                                generateWordParts="1" generateNumberParts="1"
                                catenateWords="1" catenateNumbers="1"
                                catenateAll="0" splitOnCaseChange="0"/>
                        <filter class="solr.LowerCaseFilterFactory"/>
                        <filter class="solr.ReversedWildcardFilterFactory"
                                withOriginal="true" maxPosAsterisk="3"
                                maxPosQuestion="2" maxFractionAsterisk="0.33"/>
                    </analyzer>
                    <analyzer type="query">
                        <tokenizer class="solr.WhitespaceTokenizerFactory"/>
                        <filter class="solr.SynonymFilterFactory" synonyms="synonyms.txt" ignoreCase="true"
                                expand="true"/>
                        <filter class="solr.StopFilterFactory" ignoreCase="true"
                                words="stopwords.txt" enablePositionIncrements="true"
                        />
                        <filter class="solr.WordDelimiterFilterFactory"
                                generateWordParts="1" generateNumberParts="1"
                                catenateWords="0" catenateNumbers="0"
                                catenateAll="0" splitOnCaseChange="0"/>
                        <filter class="solr.LowerCaseFilterFactory"/>
                    </analyzer>
                </fieldType>

                <fieldType name="spelltext" class="solr.TextField" positionIncrementGap="100">
                    <analyzer type="index">
                        <tokenizer class="solr.StandardTokenizerFactory"/>
                        <filter class="solr.StopFilterFactory" ignoreCase="true" words="stopwords.txt"/>
                        <filter class="solr.StandardFilterFactory"/>
                        <filter class="solr.RemoveDuplicatesTokenFilterFactory"/>
                    </analyzer>
                    <analyzer type="query">
                        <tokenizer class="solr.StandardTokenizerFactory"/>
                        <filter class="solr.SynonymFilterFactory" synonyms="synonyms.txt" ignoreCase="true"
                                expand="true"/>
                        <filter class="solr.StopFilterFactory" ignoreCase="true" words="stopwords.txt"/>
                        <filter class="solr.StandardFilterFactory"/>
                        <filter class="solr.RemoveDuplicatesTokenFilterFactory"/>
                    </analyzer>
                </fieldType>

                <!-- used for objIdentifiers -->
                <fieldType name="long_keyword" class="solr.TextField">
                    <analyzer>
                        <tokenizer class="solr.KeywordTokenizerFactory"/>
                    </analyzer>
                </fieldType>

            </types>

            <fields>

                <xsl:for-each select="./FIELD">
                    <xsl:variable name="fieldname" select="translate(@name, $uppercase, $smallcase)"/>
                    <xsl:variable name="fieldtype">
                        <xsl:choose>
                            <xsl:when test="@type='int'">sint</xsl:when>
                            <xsl:when test="@type='date'">date</xsl:when>
                            <xsl:when test="@type='ngramtext'">ngramtext</xsl:when>
                            <xsl:when test="@type='long_keyword'">long_keyword</xsl:when>
                            <xsl:when test="@type='text_ancient'">text_ancient</xsl:when>
                            <xsl:when test="@tokenizable='false'">string</xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="$textFieldType"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:variable>
                    <xsl:variable name="isMultivalued">
                        <xsl:choose>
                            <xsl:when test="@multivalued='false'">false</xsl:when>
                            <xsl:otherwise>true</xsl:otherwise>
                        </xsl:choose>
                    </xsl:variable>
                    <xsl:variable name="isStored">
                        <xsl:choose>
                            <xsl:when test="@stored='true'">true</xsl:when>
                            <xsl:otherwise>false</xsl:otherwise>
                        </xsl:choose>
                    </xsl:variable>

                    <field name="{$fieldname}" type="{$fieldtype}" indexed="{@indexable}"
                           stored="{normalize-space($isStored)}" multiValued="{normalize-space($isMultivalued)}"/>
                </xsl:for-each>

                <field name="__indexrecordidentifier" type="string" indexed="true" stored="true" multiValued="false"
                       required="true"/>

                <field name="__deleted" type="boolean" indexed="true" stored="false" default="false" omitNorms="true"
                       omitTermFreqAndPositions="true"/>

                <field name="__dsid" type="string" indexed="true" stored="true" omitNorms="true"
                       omitTermFreqAndPositions="true"/>

                <field name="__dsversion" type="tdate" indexed="true" stored="true" omitNorms="true"
                       omitTermFreqAndPositions="true"/>

                <field name="__result" type="{$textFieldType}" indexed="false" stored="true"/>

                <field name="__fulltext" type="{$textFieldType}" indexed="false" stored="true" default=""/>

                <field name="__all" type="{$textFieldType}" indexed="true" stored="false" multiValued="true"/>

                <field name="__spell" type="spelltext" indexed="true" stored="false" omitNorms="true"
                       omitTermFreqAndPositions="true"/>

                <field name="cql.serverchoice" type="{$textFieldType}" indexed="true" stored="false" multiValued="true"
                       omitNorms="true" omitTermFreqAndPositions="true"/>

                <field name="_version_" type="long" indexed="true" stored="true" multiValued="false"/>

                <!-- catchall text field that indexes tokens both normally and in reverse for efficient
                     leading wildcard queries. -->
                <field name="text_rev" type="text_rev" indexed="true" stored="false" multiValued="true"/>

                <!-- field for ping -->
                <field name="text" type="text_common" indexed="false" stored="false"/>


            </fields>

            <!-- Field to use to determine and enforce document uniqueness.
                 Unless this field is marked with required="false", it will be a required field
              -->
            <uniqueKey>__indexrecordidentifier</uniqueKey>

            <!-- field for the QueryParser to use when an explicit fieldname is absent -->
            <defaultSearchField>__all</defaultSearchField>

            <!-- SolrQueryParser configuration: defaultOperator="AND|OR" -->
            <solrQueryParser defaultOperator="OR"/>

            <xsl:for-each select="./FIELD[(@type = 'ngramtext' or @type = 'text_ancient' or not(@type)) and not(@tokenizable = 'false')]">
                <xsl:variable name="fieldname" select="translate(@name, $uppercase, $smallcase)"/>
                <copyField source="{$fieldname}" dest="__all"/>
            </xsl:for-each>

            <xsl:for-each select="./FIELD[@spellcheck = 'true']">
                <xsl:variable name="fieldname" select="translate(@name, $uppercase, $smallcase)"/>
                <copyField source="{$fieldname}" dest="__spell"/>
            </xsl:for-each>

            <copyField source="cql.serverchoice" dest="__all"/>
            <copyField source="__fulltext" dest="__all"/>


            <!-- Similarity is the scoring routine for each document vs. a query.
                 A custom similarity may be specified here, but the default is fine
                 for most applications.  -->
            <!-- <similarity class="org.apache.lucene.search.DefaultSimilarity"/> -->
            <!-- ... OR ...
                 Specify a SimilarityFactory class name implementation
                 allowing parameters to be used.
            -->
            <!--
            <similarity class="com.example.solr.CustomSimilarityFactory">
              <str name="paramkey">param value</str>
            </similarity>
            -->


        </schema>
    </xsl:template>
</xsl:stylesheet>