/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.http;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class UbiEratLupaIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(UbiEratLupaIterator.class);
    private static final int LIMIT = 500;
    private final SAXReader reader = new SAXReader();
    private final Queue<String> queue = new PriorityBlockingQueue<String>();
    private String baseUrl;
    private int offset = 0;
    private boolean onLastPage;

    public UbiEratLupaIterator() {
    }

    public UbiEratLupaIterator(String baseurl) {
        this.baseUrl = baseurl;
        this.onLastPage = false;
    }

    @Override
    public boolean hasNext() {
        if (this.queue.size() == 0) {
            if (this.onLastPage) {
                return false;
            }
            this.refillQueue();
            return this.queue.size() != 0;
        }
        return true;
    }

    private void refillQueue() {
        String url = this.baseUrl + "?limit=" + 500 + "&offset=" + this.offset;
        log.info((Object)("HTTP GET: " + url));
        try {
            URL request = new URL(url);
            Document doc = this.reader.read(request.openStream());
            for (Object o : doc.selectNodes("//monument")) {
                this.queue.add(((Node)o).asXML());
            }
            if (this.queue.size() < 500) {
                this.onLastPage = true;
            }
            this.offset += 500;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL ->  " + url, e);
        }
        catch (DocumentException e) {
            throw new RuntimeException("An error occurred while parsing the page fetched from " + url, e);
        }
        catch (IOException e) {
            throw new RuntimeException("An error occurred getting page " + url, e);
        }
    }

    @Override
    public String next() {
        return this.queue.remove();
    }

    @Override
    public void remove() {
    }
}

