package eu.dnetlib.data.download.plugins;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;

import java.util.ArrayList;
import java.util.List;

public class EagleDownloadPlugin implements DownloadPlugin {

    @Override
    public DownloadItem retrieveUrl(final DownloadItem item) {
        String url = item.getUrl();

        if ((url == null) || (url.trim().length() == 0)) return null;
        @SuppressWarnings("unchecked")
        List<String> urls = new Gson().fromJson(url, ArrayList.class);
        if ((urls == null) || (urls.size() == 0)) {
            item.setOriginalUrl(null);
            item.setUrl(null);
            item.setFileName(item.getIdItemMetadata());
            return item;
        }
        item.setOriginalUrl(urls.get(0));
        item.setUrl(urls.get(0));
        item.setFileName(item.getIdItemMetadata());
        return item;
    }

    @Override
    public Iterable<DownloadItem> retrieveUrls(final Iterable<DownloadItem> items) {

        return Iterables.transform(items, new Function<DownloadItem, DownloadItem>() {

            @Override
            public DownloadItem apply(final DownloadItem input) {
                return retrieveUrl(input);
            }
        });
    }

    @Override
    public String getPluginName() {
        return "EagleDownloadPlugin";
    }

    @Override
    public void setBasePath(final String arg0) {
        // TODO Auto-generated method stub
    }

    /**
     * {@inheritDoc}
     *
     * @see eu.dnetlib.data.download.rmi.DownloadPlugin#getRegularExpression()
     */
    @Override
    public List<String> getRegularExpression() {
        // TODO Auto-generated method stub
        return null;
    }

    /**
     * {@inheritDoc}
     *
     * @see eu.dnetlib.data.download.rmi.DownloadPlugin#setRegularExpression(java.util.List)
     */
    @Override
    public void setRegularExpression(final List<String> regularExpression) {
        // TODO Auto-generated method stub

    }

}
