/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.mediawiki;

import java.net.URL;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class MediawikiIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(MediawikiIterator.class);
    private final Queue<String> queue = new PriorityBlockingQueue<String>();
    private final SAXReader reader = new SAXReader();
    private String baseUrl;
    private String apnamespace;
    private String apcontinue;
    private boolean started;

    public MediawikiIterator() {
    }

    public MediawikiIterator(String baseUrl, String apnamespace) {
        this.baseUrl = baseUrl;
        this.apnamespace = apnamespace;
        this.started = false;
    }

    private void verifyStarted() {
        if (!this.started) {
            this.apcontinue = this.firstPage();
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        Queue<String> queue = this.queue;
        synchronized (queue) {
            this.verifyStarted();
            return !this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        Queue<String> queue = this.queue;
        synchronized (queue) {
            this.verifyStarted();
            String res = this.queue.poll();
            while (this.queue.isEmpty() && this.apcontinue != null && !this.apcontinue.isEmpty()) {
                this.apcontinue = this.otherPages(this.apcontinue);
            }
            return res;
        }
    }

    @Override
    public void remove() {
    }

    private String firstPage() {
        String url = this.baseUrl + "?action=query&list=allpages&apnamespace=" + this.apnamespace + "&aplimit=50&format=xml";
        log.info((Object)("Downloading first page using url: " + url));
        return this.downloadPage(url);
    }

    private String otherPages(String apcontinue) {
        return this.downloadPage(this.baseUrl + "?action=query&list=allpages&apnamespace=" + this.apnamespace + "&aplimit=50&format=xml&apcontinue=" + apcontinue);
    }

    private String downloadPage(String url) {
        try {
            log.info((Object)("HTTP GET: " + url));
            URL request = new URL(url);
            Document doc = this.reader.read(request.openStream());
            String nextApContinue = doc.valueOf("//*[local-name()='query-continue']//*[local-name()='allpages']/@apcontinue");
            String pagesUrl = "?action=wbgetentities&format=xml&ids=";
            for (Object o : doc.selectNodes("//*[local-name()='p']")) {
                String[] titleTokens = ((Element)o).valueOf("@title").split(":");
                pagesUrl = pagesUrl + titleTokens[1] + "|";
            }
            pagesUrl = pagesUrl.substring(0, pagesUrl.length() - 1);
            URL pages = new URL(this.baseUrl + pagesUrl);
            doc = this.reader.read(pages.openStream());
            for (Object o : doc.selectNodes("//*[local-name()='entity']")) {
                this.queue.add(((Node)o).asXML());
            }
            return nextApContinue;
        }
        catch (Exception e) {
            throw new RuntimeException("Error processing data from: " + url, e);
        }
    }
}

