package eu.dnetlib.data.collector.plugins.http;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;

public class UbiEratLupaIterator implements Iterator<String> {
    private static final Log log = LogFactory.getLog(UbiEratLupaIterator.class);
    private static final int LIMIT = 500;
    private final SAXReader reader = new SAXReader();
    private final Queue<String> queue = new PriorityBlockingQueue<String>();
    private String baseUrl;
    private int offset = 0;
    private boolean onLastPage;

    public UbiEratLupaIterator() {
    }

    public UbiEratLupaIterator(String baseurl) {
        this.baseUrl = baseurl;
        this.onLastPage = false;
    }

    @Override
    public boolean hasNext() {
        if (queue.size() == 0) {
            if (onLastPage) {
                return false;
            } else {
                refillQueue();
                return queue.size() != 0;
            }
        } else {
            return true;
        }
    }

    private void refillQueue() {
        String url = baseUrl + "?limit=" + LIMIT + "&offset=" + offset;
        log.info("HTTP GET: " + url);
        URL request;
        try {
            request = new URL(url);
            Document doc = reader.read(request.openStream());

            for (Object o : doc.selectNodes("//monument")) {
                queue.add(((Node) o).asXML());
            }

            if (queue.size() < LIMIT) {
                onLastPage = true;
            }
            offset = offset + LIMIT;
        } catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL ->  " + url, e);
        } catch (DocumentException e) {
            throw new RuntimeException("An error occurred while parsing the page fetched from " + url, e);
        } catch (IOException e) {
            throw new RuntimeException("An error occurred getting page " + url, e);
        }

    }

    @Override
    public String next() {
        return queue.remove();
    }

    @Override
    public void remove() {
    }

}
