package eu.dnetlib.msro.eagle.workflows.nodes.backlink.translations;

import java.util.Iterator;
import java.util.List;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class TranslationBacklinkJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(TranslationBacklinkJobNode.class);

	private String inputEprParam;
	private String outputEprParam;

	private MappedResultSetFactory mappedResultSetFactory;
	private ResultSetClientFactory resultSetClientFactory;

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final W3CEndpointReference inputEpr = new EPRUtils().getEpr(token.getEnv().getAttribute(inputEprParam));

		// retrieve Translation mdStore
		String xQueryTranslation = "for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') "
				+ "where $x//WORKFLOW_NAME = 'index' and $x//PARAM[./@name = 'providerName']/text() = 'EAGLE MediaWiki' "
				+ "return $x//PARAM[./@name='mdId']/text()";
		List<String> queryResult = serviceLocator.getService(ISLookUpService.class).quickSearchProfile(xQueryTranslation);
		if (queryResult == null || queryResult.size() == 0) {
			token.getEnv().setAttribute(outputEprParam, inputEpr.toString());
			return Arc.DEFAULT_ARC;
		}
		String translationStoreId = queryResult.get(0);
		final W3CEndpointReference translationsEpr = serviceLocator.getService(MDStoreService.class).deliverMDRecords(translationStoreId, "", "", "");

		final Iterator<String> translationIterator = resultSetClientFactory.getClient(translationsEpr).iterator();
		final W3CEndpointReference epr = mappedResultSetFactory.createMappedResultSet(inputEpr, new TranslationBacklinkUnaryFunction(translationIterator));

		token.getEnv().setAttribute(outputEprParam, epr.toString());

		return Arc.DEFAULT_ARC;
	}

	public String getInputEprParam() {
		return inputEprParam;
	}

	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public MappedResultSetFactory getMappedResultSetFactory() {
		return mappedResultSetFactory;
	}

	@Required
	public void setMappedResultSetFactory(final MappedResultSetFactory mappedResultSetFactory) {
		this.mappedResultSetFactory = mappedResultSetFactory;
	}

	public ResultSetClientFactory getResultSetClientFactory() {
		return resultSetClientFactory;
	}

	@Required
	public void setResultSetClientFactory(final ResultSetClientFactory resultSetClientFactory) {
		this.resultSetClientFactory = resultSetClientFactory;
	}

}
