/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.hdfs;

import eu.dnetlib.data.hadoop.hdfs.SequenceFileIterator;
import eu.dnetlib.miscutils.collections.Pair;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;

public final class SequenceFileIterable<K extends Writable, V extends Writable>
implements Iterable<Pair<K, V>> {
    private final Path path;
    private final boolean reuseKeyValueInstances;
    private final Configuration conf;

    public SequenceFileIterable(Path path, Configuration conf) {
        this(path, false, conf);
    }

    public SequenceFileIterable(Path path, boolean reuseKeyValueInstances, Configuration conf) {
        this.path = path;
        this.reuseKeyValueInstances = reuseKeyValueInstances;
        this.conf = conf;
    }

    @Override
    public Iterator<Pair<K, V>> iterator() {
        try {
            return new SequenceFileIterator(this.path, this.reuseKeyValueInstances, this.conf);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(this.path.toString(), ioe);
        }
    }
}

