/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform;

import eu.dnetlib.data.transform.XsltRowTransformer;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;

public class XsltRowTransformerFactory {
    private static final Log log = LogFactory.getLog(XsltRowTransformerFactory.class);

    public XsltRowTransformer getTransformer(String xslt) {
        try {
            if (xslt == null || xslt.isEmpty()) {
                return new XsltRowTransformer(null);
            }
            TransformerFactory factory = TransformerFactory.newInstance();
            if (log.isDebugEnabled()) {
                log.debug((Object)("using transformer factory: '" + factory.getClass().getCanonicalName() + "'"));
            }
            return new XsltRowTransformer(factory.newTransformer((Source)new DocumentSource(new SAXReader().read((Reader)new StringReader(xslt)))));
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating transformer from xslt:\n" + xslt, e);
        }
    }

    public static XsltRowTransformer newInstance(String xslt) {
        return new XsltRowTransformerFactory().getTransformer(xslt);
    }
}

