package eu.dnetlib.data.transform;

import java.io.StringReader;

import javax.xml.transform.TransformerFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;

public class XsltRowTransformerFactory {

	private static final Log log = LogFactory.getLog(XsltRowTransformerFactory.class); // NOPMD by marko on 11/24/08 5:02 PM
	
	public XsltRowTransformer getTransformer(final String xslt) {
		try {
			if ((xslt == null) || xslt.isEmpty()) { return new XsltRowTransformer(null); }

			final TransformerFactory factory = TransformerFactory.newInstance();
			
			if (log.isDebugEnabled()) {
				log.debug("using transformer factory: '" + factory.getClass().getCanonicalName() + "'");
			}
			
			return new XsltRowTransformer(factory.newTransformer(new DocumentSource(new SAXReader().read(new StringReader(xslt)))));
		} catch (Exception e) {
			throw new RuntimeException("Error generating transformer from xslt:\n" + xslt, e);
		}
	}

	public static XsltRowTransformer newInstance(final String xslt) {
		return new XsltRowTransformerFactory().getTransformer(xslt);
	}
}
