package eu.dnetlib.data.transform;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Maps;

public class Row implements Iterable<Column<String, byte[]>> {

	private String columnFamily;

	private String key;

	private Map<String, Column<String, byte[]>> columns;

	public Row(final String columnFamily, final String key) {
		this.columnFamily = columnFamily;
		this.key = key;
		this.columns = Maps.newHashMap();
	}

	public Row(final String columnFamily, final String key, final List<Column<String, byte[]>> columns) {
		this(columnFamily, key);
		this.setColumns(columns);
	}

	public void addColumn(final Column<String, byte[]> column) {
		getColumns().add(column);
	}

	public String getKey() {
		return key;
	}

	public Collection<Column<String, byte[]>> getColumns() {
		return columns.values();
	}

	public Column<String, byte[]> getColumn(final String name) {
		return columns.get(name);
	}

	public void setColumns(final List<Column<String, byte[]>> columns) {
		this.columns.clear();
		for (Column<String, byte[]> col : columns) {
			this.columns.put(col.getName(), col);
		}
	}

	public String getColumnFamily() {
		return columnFamily;
	}

	@Override
	public Iterator<Column<String, byte[]>> iterator() {
		return getColumns().iterator();
	}

	@Override
	public String toString() {
		return "\nRow [ KEY: " + key + ",\n\tCF: " + columnFamily + "\n\tCOLS: {" + columns + "}]";
	}

}
