package eu.dnetlib.data.hadoop.config;

import java.io.IOException;
import java.util.Map.Entry;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

/**
 * Factory bean for hadoop cluster configuration object
 * 
 * @author claudio
 * 
 */
public class ConfigurationFactory implements FactoryBean<Configuration> {

	private static final Log log = LogFactory.getLog(ConfigurationFactory.class); // NOPMD by marko on 11/24/08 5:02 PM

	private Resource defaults;

	public Configuration getConfiguration() {
		try {
			return getObject();
		} catch (Exception e) {
			throw new IllegalStateException("Unable to load hadoop configuration", e);
		}
	}

	@Override
	public Configuration getObject() throws Exception {
		return initConfiguration(defaultProperties());
	}

	@Override
	public Class<?> getObjectType() {
		return Configuration.class;
	}

	@Override
	public boolean isSingleton() {
		return true;
	}

	private Configuration initConfiguration(final Properties p) {
		final Configuration conf = new Configuration(false);
		for (Entry<Object, Object> e : p.entrySet()) {
			conf.set(e.getKey().toString(), e.getValue().toString());
			log.info(e.getKey().toString() + ": " + conf.get(e.getKey().toString()));
		}
		return conf;
	}

	private Properties defaultProperties() throws IOException {
		Properties p = new Properties();
		p.load(defaults.getInputStream());
		return p;
	}

	public Resource getDefaults() {
		return defaults;
	}

	@Required
	public void setDefaults(Resource defaults) {
		this.defaults = defaults;
	}

}
