/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform;

import eu.dnetlib.data.transform.XsltRowTransformer;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;

public class XsltRowTransformerFactory {
    private static final Log log = LogFactory.getLog(XsltRowTransformerFactory.class);

    public XsltRowTransformer getTransformer(String xslt) {
        return this.doGetTransformer(xslt, null);
    }

    public XsltRowTransformer getTransformer(String xslt, Map<String, Object> params) {
        return this.doGetTransformer(xslt, params);
    }

    private XsltRowTransformer doGetTransformer(String xslt, Map<String, Object> params) {
        try {
            if (xslt == null || xslt.isEmpty()) {
                return new XsltRowTransformer(null);
            }
            TransformerFactory factory = TransformerFactory.newInstance();
            if (log.isDebugEnabled()) {
                log.debug((Object)("using transformer factory: '" + factory.getClass().getCanonicalName() + "'"));
            }
            Transformer t = factory.newTransformer((Source)new DocumentSource(new SAXReader().read((Reader)new StringReader(xslt))));
            if (!MapUtils.isEmpty(params)) {
                for (Map.Entry<String, Object> e : params.entrySet()) {
                    log.debug((Object)String.format("using xslt param: %s - %s", e.getKey(), e.getValue()));
                    t.setParameter(e.getKey(), e.getValue());
                }
            }
            return new XsltRowTransformer(t);
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating transformer from xslt:\n" + xslt, e);
        }
    }

    public static XsltRowTransformer newInstance(String xslt) {
        return new XsltRowTransformerFactory().getTransformer(xslt);
    }

    public static XsltRowTransformer newInstance(String xslt, Map<String, Object> params) {
        return new XsltRowTransformerFactory().getTransformer(xslt, params);
    }
}

