/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.utils;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.data.provision.index.rmi.IndexServiceException;
import eu.dnetlib.functionality.index.model.Any;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.request.LukeRequest;
import org.apache.solr.client.solrj.response.LukeResponse;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.springframework.beans.factory.annotation.Required;

public class RemoteSolrAdministrator {
    private static final Log log = LogFactory.getLog(RemoteSolrAdministrator.class);
    private static String createURLRequest = "http://%s:%s/solr/admin/collections?action=CREATE&name=%s&numShards=%s&collection.configName=%s";
    private static String reloadURLRequest = "http://%s:%s/solr/admin/collections?action=RELOAD&name=%s";
    private HttpClient httpClient;
    protected Map<String, Map<String, Any.ValueType>> cachedSchema = new HashMap<String, Map<String, Any.ValueType>>();

    public boolean createSolrIndex(String host, String port, String collectionName, String numShard, String collectionConfigName) throws IndexServiceException {
        HttpResponse response;
        this.httpClient = new DefaultHttpClient();
        HttpGet request = new HttpGet(this.generateCreateIndexRequest(host, port, collectionName, numShard, collectionConfigName));
        try {
            response = this.httpClient.execute((HttpUriRequest)request);
        }
        catch (Exception e) {
            throw new IndexServiceException("Unable to send request to solr server", (Throwable)e);
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IndexServiceException("Error on creating index the error code from solr is" + response.toString());
        }
        return false;
    }

    public boolean indexCollectionExists(String indexCollectionId, CloudSolrServer server) {
        Watcher watcher = new Watcher(){

            public void process(WatchedEvent arg0) {
            }
        };
        try {
            byte[] data;
            SolrZkClient client = server.getZkStateReader().getZkClient();
            if (!client.isConnected()) {
                server.shutdown();
                server.connect();
            }
            if ((data = client.getData("/clusterstate.json", watcher, new Stat(), true)) == null) {
                return false;
            }
            String jsonLine = new String(data);
            JsonElement jelement = new JsonParser().parse(jsonLine);
            JsonObject jobject = jelement.getAsJsonObject();
            if (jobject.has(indexCollectionId)) {
                server.setDefaultCollection(indexCollectionId);
                server.connect();
                SolrPingResponse status = server.ping();
                return (Integer)status.getResponseHeader().get("status") == 0;
            }
            return false;
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    private Any.ValueType resolveSolrTypeClassName(String solrTypeName) {
        if (solrTypeName.contains("LongField")) {
            return Any.ValueType.LONG;
        }
        if (solrTypeName.contains("IntField")) {
            return Any.ValueType.LONG;
        }
        if (solrTypeName.contains("short")) {
            return Any.ValueType.LONG;
        }
        if (solrTypeName.contains("float")) {
            return Any.ValueType.DOUBLE;
        }
        if (solrTypeName.contains("double")) {
            return Any.ValueType.DOUBLE;
        }
        if (solrTypeName.contains("date")) {
            return Any.ValueType.DATETIME;
        }
        return Any.ValueType.STRING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Any.ValueType> getFieldNamesAndTypes(String coreName, SolrServer server) throws IndexServiceException {
        try {
            if (this.cachedSchema.get(coreName) == null) {
                Map<String, Map<String, Any.ValueType>> map = this.cachedSchema;
                synchronized (map) {
                    Map<String, Any.ValueType> schema = this.readFieldNamesAndTypes(coreName, server);
                    log.info((Object)("setting cache for schema of collection: " + coreName));
                    this.cachedSchema.put(coreName, schema);
                }
            }
            return this.cachedSchema.get(coreName);
        }
        catch (Exception e) {
            throw new IndexServiceException("Unable to get Schema for " + coreName + " exception", (Throwable)e);
        }
    }

    private Map<String, Any.ValueType> readFieldNamesAndTypes(String coreName, SolrServer server) throws SolrServerException, IOException {
        LukeRequest request = new LukeRequest();
        request.setShowSchema(true);
        request.setNumTerms(0);
        LukeResponse response = request.process(server);
        Map fieldInfos = response.getFieldInfo();
        Map fieldTypeInfos = response.getFieldTypeInfo();
        HashMap result = Maps.newHashMap();
        for (LukeResponse.FieldInfo fieldInfo : fieldInfos.values()) {
            LukeResponse.FieldTypeInfo fieldTypeInfo = (LukeResponse.FieldTypeInfo)fieldTypeInfos.get(fieldInfo.getType());
            String fieldName = fieldTypeInfo.getName().toLowerCase();
            Any.ValueType fieldType = this.resolveSolrTypeClassName(fieldName);
            result.put(fieldInfo.getName(), fieldType);
        }
        return result;
    }

    private String generateCreateIndexRequest(String host, String port, String collectionName, String numShard, String collectionConfigName) {
        return String.format(createURLRequest, host, port, collectionName, numShard, collectionConfigName);
    }

    private String generateUpdateIndexRequest(String host, String port, String collectionName) {
        return String.format(reloadURLRequest, host, port, collectionName);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Required
    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void reloadCollection(String host, String port, String collectionName) throws IndexServiceException {
        HttpResponse response;
        this.httpClient = new DefaultHttpClient();
        log.info((Object)("creating the request of reload index " + this.generateUpdateIndexRequest(host, port, collectionName)));
        HttpGet request = new HttpGet(this.generateUpdateIndexRequest(host, port, collectionName));
        try {
            response = this.httpClient.execute((HttpUriRequest)request);
        }
        catch (Exception e) {
            throw new IndexServiceException("Unable to send request to solr server", (Throwable)e);
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IndexServiceException("Error on reloading index the error code from solr is" + response.toString());
        }
    }
}

