/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index;

import com.google.common.collect.Maps;
import eu.dnetlib.data.provision.index.rmi.IndexServiceException;
import eu.dnetlib.functionality.index.AbstractBackendDescriptor;
import eu.dnetlib.functionality.index.IndexCollection;
import eu.dnetlib.functionality.index.IndexServerDAO;
import eu.dnetlib.functionality.index.SolrIndexCollection;
import eu.dnetlib.functionality.index.cql.CqlValueTransformerMap;
import eu.dnetlib.functionality.index.feed.DocumentMapperFactory;
import eu.dnetlib.functionality.index.model.Any;
import eu.dnetlib.functionality.index.query.IndexQueryFactory;
import eu.dnetlib.functionality.index.query.QueryResponseFactory;
import eu.dnetlib.functionality.index.query.SolrIndexQueryFactory;
import eu.dnetlib.functionality.index.query.SolrIndexQueryResponseFactory;
import eu.dnetlib.functionality.index.solr.cql.SolrTypeBasedCqlValueTransformerMapFactory;
import eu.dnetlib.functionality.index.solr.feed.SolrDocumentMapperFactory;
import eu.dnetlib.functionality.index.utils.IndexConfigFactory;
import eu.dnetlib.functionality.index.utils.MetadataReference;
import eu.dnetlib.functionality.index.utils.RemoteSolrAdministrator;
import eu.dnetlib.functionality.index.utils.ZkUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class SolrIndexServerDAO
extends AbstractBackendDescriptor
implements IndexServerDAO {
    private static final Log log = LogFactory.getLog(SolrIndexServerDAO.class);
    private Map<MetadataReference, HttpSolrServer> serverMap = Maps.newHashMap();
    @Autowired
    private ZkUtils zkUtils;
    @Autowired
    private SolrIndexQueryResponseFactory queryResponseFactory;
    @Autowired
    private SolrIndexQueryFactory solrIndexQueryFactory;
    @Autowired
    private SolrDocumentMapperFactory solrDocumentMapperFactory;
    private RemoteSolrAdministrator solrAdministrator;
    @Autowired
    private SolrTypeBasedCqlValueTransformerMapFactory tMapFactory;

    public IndexCollection createIndexCollection(MetadataReference mdref, String fields) throws IndexServiceException {
        try {
            CloudSolrServer server = new CloudSolrServer((String)this.getEndpoint().get("address"));
            server.connect();
            if (!this.solrAdministrator.indexCollectionExists(mdref.toString(), server)) {
                HashMap params = Maps.newHashMap();
                params.put("numShards", this.getServiceProperties().get("numShards"));
                params.put("replicationFactor", this.getServiceProperties().get("replicationFactor"));
                for (IndexConfigFactory.CONFIG_PARAMS param_Name : IndexConfigFactory.CONFIG_PARAMS.values()) {
                    params.put(param_Name.toString(), this.getServiceProperties().get(param_Name.toString()));
                }
                params.put(IndexConfigFactory.CONFIG_PARAMS.indexDataDir.toString(), mdref.toString());
                this.zkUtils.uploadZookeperConfig(server.getZkStateReader().getZkClient(), mdref.toString(), this.parse(fields), params, false);
                this.solrAdministrator.createSolrIndex((String)this.getServiceProperties().get("host"), (String)this.getServiceProperties().get("port"), mdref.toString(), (String)this.getServiceProperties().get("numShards"), mdref.toString());
            }
            server.getZkStateReader().close();
            server.shutdown();
            HttpSolrServer newServer = this.getServer(mdref);
            return new SolrIndexCollection(newServer, (QueryResponseFactory<QueryResponse>)this.queryResponseFactory);
        }
        catch (Exception e) {
            log.error((Object)"Error on creating IndexCollection", (Throwable)e);
            throw new IndexServiceException("Error on creating IndexCollection", (Throwable)e);
        }
    }

    public void UpdateIndexCollection(MetadataReference mdRef, Document fields) throws IndexServiceException {
        try {
            CloudSolrServer server = new CloudSolrServer((String)this.getEndpoint().get("address"));
            server.connect();
            HashMap params = Maps.newHashMap();
            params.put("numShards", this.getServiceProperties().get("numShards"));
            params.put("replicationFactor", this.getServiceProperties().get("replicationFactor"));
            for (IndexConfigFactory.CONFIG_PARAMS param_Name : IndexConfigFactory.CONFIG_PARAMS.values()) {
                params.put(param_Name.toString(), this.getServiceProperties().get(param_Name.toString()));
            }
            params.put(IndexConfigFactory.CONFIG_PARAMS.indexDataDir.toString(), mdRef.toString());
            this.zkUtils.uploadZookeperConfig(server.getZkStateReader().getZkClient(), mdRef.toString(), fields, params, true);
            server.getZkStateReader().close();
            server.shutdown();
            this.solrAdministrator.reloadCollection((String)this.getServiceProperties().get("host"), (String)this.getServiceProperties().get("port"), mdRef.toString());
        }
        catch (Exception e) {
            log.error((Object)"Error on updating IndexCollection", (Throwable)e);
            throw new IndexServiceException("Error on updating IndexCollection", (Throwable)e);
        }
    }

    private Document parse(String fields) throws IndexServiceException {
        try {
            return new SAXReader().read((Reader)new StringReader(fields));
        }
        catch (DocumentException e) {
            throw new IndexServiceException("unable to parse fields: " + fields, (Throwable)e);
        }
    }

    public IndexCollection getIndexCollection(MetadataReference mdref) throws IndexServiceException {
        HttpSolrServer newServer = this.getServer(mdref);
        return new SolrIndexCollection(newServer, (QueryResponseFactory<QueryResponse>)this.queryResponseFactory);
    }

    public Map<String, Any.ValueType> getSchema(MetadataReference mdRef) throws IndexServiceException {
        return this.solrAdministrator.getFieldNamesAndTypes(mdRef.toString(), (SolrServer)this.getServer(mdRef));
    }

    public CqlValueTransformerMap getCqlValueTransformerMap(MetadataReference mdRef) throws IndexServiceException {
        return this.tMapFactory.getIt(this.getSchema(mdRef));
    }

    public DocumentMapperFactory getDocumentMapperFactory() throws IndexServiceException {
        return this.solrDocumentMapperFactory;
    }

    public void shutdown(MetadataReference mdRef) throws IndexServiceException {
        this.getServer(mdRef).shutdown();
    }

    private HttpSolrServer getServer(MetadataReference mdRef) throws IndexServiceException {
        if (!this.serverMap.containsKey(mdRef)) {
            String host = (String)this.getServiceProperties().get("host");
            String port = (String)this.getServiceProperties().get("port");
            HttpSolrServer server = new HttpSolrServer("http://" + host + ":" + port + "/solr/" + mdRef.toString());
            this.serverMap.put(mdRef, server);
        }
        return this.serverMap.get(mdRef);
    }

    public RemoteSolrAdministrator getSolrAdministrator() {
        return this.solrAdministrator;
    }

    @Required
    public void setSolrAdministrator(RemoteSolrAdministrator solrAdministrator) {
        this.solrAdministrator = solrAdministrator;
    }

    public IndexQueryFactory getIndexQueryFactory() {
        return this.solrIndexQueryFactory;
    }
}

