package eu.dnetlib.functionality.index.utils;

import java.util.Map;
import java.util.Map.Entry;

import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;

import eu.dnetlib.data.provision.index.rmi.IndexServiceException;

public class IndexConfigFactory {

	private static final Log log = LogFactory.getLog(IndexConfigFactory.class); // NOPMD
																				// by
																				// marko
																				// on
																				// 11/24/08
																				// 5:02
																				// PM

	public enum CONFIG_PARAMS {
		// TODO replace with actual values
		luceneMatchVersion, serverLibPath, indexDataDir, filterCacheSize, filterCacheInitialSize, queryCacheSize, queryCacheInitialSize, documentCacheSize, documentCacheInitialSize, queryResultWindowSize, queryResultMaxDocCached, ramBufferSizeMB, mergeFactor, termIndexInterval, autosoftcommit, autocommit, maxIndexingThreads;

		static boolean isValid(final String v) {
			try {
				CONFIG_PARAMS.valueOf(v);
				return true;
			} catch (Throwable e) {
				return false;
			}
		}
	};

	/**
	 * Index configuration template.
	 */
	private StringTemplate solrConfig;

	/**
	 * @param docIn
	 *            input document
	 * @return the application of the schemaXslt transformation to the docIn
	 *         document
	 * @throws IndexServiceException
	 */
	public String getConfig(final Map<String, String> params)
			throws IndexServiceException {
		final StringTemplate conf = new StringTemplate(getSolrConfig()
				.getTemplate());
		for (Entry<String, String> e : filter(params).entrySet()) {
			log.debug("setting conf property [" + e.getKey() + ":"
					+ e.getValue() + "]");
			conf.setAttribute(e.getKey(), e.getValue());
		}
		return conf.toString();
	}

	private Map<String, String> filter(final Map<String, String> params) {
		return Maps.filterKeys(params, new Predicate<String>() {

			@Override
			public boolean apply(final String input) {
				return CONFIG_PARAMS.isValid(input);
			}
		});
	}

	public StringTemplate getSolrConfig() {
		return solrConfig;
	}

	@Required
	public void setSolrConfig(final StringTemplate solrConfig) {
		this.solrConfig = solrConfig;
	}

}
