/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import eu.dnetlib.data.provision.index.rmi.IndexServiceException;
import eu.dnetlib.functionality.index.IndexCollection;
import eu.dnetlib.functionality.index.model.document.IndexDocument;
import eu.dnetlib.functionality.index.model.util.SolrIndexDocument;
import eu.dnetlib.functionality.index.query.IndexQuery;
import eu.dnetlib.functionality.index.query.IndexQueryResponse;
import eu.dnetlib.functionality.index.query.QueryResponseFactory;
import eu.dnetlib.functionality.index.query.QueryResponseParser;
import eu.dnetlib.functionality.index.query.SolrIndexQuery;
import eu.dnetlib.functionality.index.query.SolrIndexQueryResponse;
import eu.dnetlib.functionality.index.utils.MetadataReference;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;

public class SolrIndexCollection
implements IndexCollection {
    private static final Log log = LogFactory.getLog(SolrIndexCollection.class);
    public static final int STATUS_INDEX_OK = 0;
    private HttpSolrServer server;
    private QueryResponseFactory<QueryResponse> queryResponseFactory;

    public SolrIndexCollection(HttpSolrServer newServer, QueryResponseFactory<QueryResponse> queryResponseFactory) {
        this.server = newServer;
        this.queryResponseFactory = queryResponseFactory;
    }

    public boolean add(IndexDocument doc) throws IndexServiceException {
        SolrIndexDocument solrDocument = (SolrIndexDocument)doc;
        try {
            UpdateResponse response = this.server.add(solrDocument.getSolrDocument());
            return response.getStatus() == 0;
        }
        catch (Exception e) {
            throw new IndexServiceException("Unable to add document", (Throwable)e);
        }
    }

    public boolean addAll(Iterator<IndexDocument> docs) throws IndexServiceException {
        Iterator solrDocs = Iterators.transform(docs, (Function)new Function<IndexDocument, SolrInputDocument>(){

            public SolrInputDocument apply(IndexDocument doc) {
                SolrIndexDocument solrDocument = (SolrIndexDocument)doc;
                return solrDocument.getSolrDocument();
            }
        });
        try {
            UpdateResponse response = this.server.add((Collection)Lists.newArrayList((Iterator)solrDocs));
            return response.getStatus() == 0;
        }
        catch (Exception e) {
            throw new IndexServiceException("Unable to add document", (Throwable)e);
        }
    }

    public boolean addAll(Collection<IndexDocument> docs) throws IndexServiceException {
        return this.addAll(docs.iterator());
    }

    public boolean deleteIndex(String dsId) throws IndexServiceException {
        return this.doDelete("__dsid : \"" + dsId + "\"");
    }

    public boolean deleteByQuery(String query, String dsId) throws IndexServiceException {
        if (StringUtils.isBlank((String)dsId)) {
            return this.doDelete(query);
        }
        return this.doDelete(query + " AND " + "__dsid" + " : \"" + dsId + "\"");
    }

    protected boolean doDelete(String query) throws IndexServiceException {
        try {
            log.debug((Object)("delete by query: " + query));
            return this.server.deleteByQuery(query).getStatus() == 0;
        }
        catch (Exception e) {
            throw new IndexServiceException("unable to run delete by query: " + query, (Throwable)e);
        }
    }

    public boolean commit() throws IndexServiceException {
        try {
            return this.server.commit().getStatus() == 0;
        }
        catch (Exception e) {
            throw new IndexServiceException("unable to commit", (Throwable)e);
        }
    }

    public QueryResponseParser lookup(IndexQuery contextualQuery, MetadataReference mdRef) throws IndexServiceException {
        SolrIndexQuery query = (SolrIndexQuery)contextualQuery;
        try {
            SolrIndexQueryResponse response = new SolrIndexQueryResponse(this.server.query((SolrParams)query));
            return this.queryResponseFactory.getQueryResponseParser((IndexQueryResponse)response, mdRef);
        }
        catch (SolrServerException e) {
            log.error((Object)"Unable to execute lookup", (Throwable)e);
            throw new IndexServiceException((Throwable)e);
        }
    }
}

