package eu.dnetlib.data.mapreduce.hbase.index;

import java.io.IOException;
import java.util.Properties;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;

import eu.dnetlib.data.mapreduce.JobParams;
import eu.dnetlib.data.mapreduce.hbase.AbstractHBaseMapReduceJob;

public class IndexFeedJob extends AbstractHBaseMapReduceJob {

	@Override
	public Job setJobDetails(Job job, Properties p) {

		job.setInputFormatClass(SequenceFileInputFormat.class);
		try {
			SequenceFileInputFormat.setInputPaths(job, p.getProperty(JobParams.MAPRED_INPUT_DIR));
			SequenceFileOutputFormat.setOutputPath(job, new Path(p.getProperty(JobParams.INDEX_ROTTEN_FILE)));
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
		job.setMapperClass(IndexFeedMapper.class);
		job.setMapOutputKeyClass(Text.class);
		job.setMapOutputValueClass(Text.class);

		job.setNumReduceTasks(0);

		job.getConfiguration().setBoolean("mapred.map.tasks.speculative.execution", false);
		job.getConfiguration().setBoolean("mapreduce.map.speculative", false);

		job.getConfiguration().setBoolean("mapred.compress.map.output", true);

		return job;
	}

}
