/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.actions;

import java.io.IOException;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class CommitActionsMapper
extends TableMapper<ImmutableBytesWritable, Put> {
    private String set = null;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.set = context.getConfiguration().get("set");
        if (this.set != null) {
            System.out.println("Committing set: " + this.set);
        } else {
            System.out.println("Committing ALL sets");
        }
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        if (this.set == null || value.getColumnLatest(Bytes.toBytes((String)"set"), Bytes.toBytes((String)this.set)) != null) {
            System.out.println("Processing action " + Bytes.toString((byte[])key.copyBytes()));
            byte[] cf = Bytes.toBytes((String)"target");
            byte[] tkey = value.getValue(cf, Bytes.toBytes((String)"rowKey"));
            byte[] tcf = value.getValue(cf, Bytes.toBytes((String)"columnFamily"));
            byte[] tc = value.getValue(cf, Bytes.toBytes((String)"column"));
            byte[] tv = value.getValue(cf, Bytes.toBytes((String)"content"));
            Put put = new Put(tkey);
            put.add(tcf, tc, tv);
            context.getCounter("Actions", Bytes.toString((byte[])tcf)).increment(1L);
            context.write((Object)new ImmutableBytesWritable(tkey), (Object)put);
        }
    }
}

