/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import eu.dnetlib.data.mapreduce.hbase.AbstractHBaseMapReduceJob;
import eu.dnetlib.data.mapreduce.hbase.dedup.FindDedupCandidatePersonsMapper;
import eu.dnetlib.data.mapreduce.hbase.dedup.FindDedupCandidatePersonsReducer;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;

public class FindDedupCandidatePersonsJob
extends AbstractHBaseMapReduceJob {
    private static final String PERSON_SCAN_PREFIX = TypeProtos.Type.person.getNumber() + "|";

    @Override
    public Job setJobDetails(Job job, Properties p) {
        p.setProperty("mapred.reduce.tasks.speculative.execution", "true");
        this.initMapper(job, this.getScan(p), p.getProperty("hbase.source.table"));
        job.setNumReduceTasks(100);
        return job;
    }

    private Scan getScan(Properties p) {
        Scan scan = new Scan();
        scan.setCaching(100);
        scan.setCacheBlocks(false);
        scan.setFilter((Filter)new PrefixFilter(Bytes.toBytes((String)PERSON_SCAN_PREFIX)));
        return scan;
    }

    private void initMapper(Job job, Scan scan, String sourceTable) {
        try {
            TableMapReduceUtil.initTableMapperJob((String)sourceTable, (Scan)scan, FindDedupCandidatePersonsMapper.class, Text.class, Text.class, (Job)job);
            TableMapReduceUtil.initTableReducerJob((String)sourceTable, FindDedupCandidatePersonsReducer.class, (Job)job);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

