package eu.dnetlib.data.mapreduce.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;

import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.SpecialTrustProtos.SpecialTrust;

public class TrustOrdering extends Ordering<Oaf> {

	@Override
	public int compare(Oaf left, Oaf right) {
		String lTrust = left.getDataInfo().getTrust();
		String rTrust = right.getDataInfo().getTrust();

		if (lTrust.equals(rTrust)) return 0;

		if (lTrust.equals(SpecialTrust.INFINITE.toString())) return 1;
		if (rTrust.equals(SpecialTrust.INFINITE.toString())) return -1;

		if (lTrust.equals(SpecialTrust.NEUTRAL.toString())) return 1;
		if (rTrust.equals(SpecialTrust.NEUTRAL.toString())) return -1;

		return Float.compare(Float.parseFloat(lTrust), Float.parseFloat(rTrust));
	}

	public static ImmutableList<Oaf> sort(Iterable<Oaf> entities) {
		return new TrustOrdering().immutableSortedCopy(entities);
	}

}
