/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.proto.DedupProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetOafXsltFunctions;
import eu.dnetlib.pace.util.DedupConfig;
import eu.dnetlib.pace.util.DedupConfigLoader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupFindRootsMapper
extends TableMapper<ImmutableBytesWritable, Put> {
    private static final boolean WRITE_TO_WAL = false;
    private DedupConfig dedupConf;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.dedupConf = DedupConfigLoader.load((String)context.getConfiguration().get("dedup.wf.conf"));
        System.out.println("dedup findRoots mapper\nwf conf: " + this.dedupConf.toString());
    }

    protected void map(ImmutableBytesWritable rowkey, Result value, Mapper.Context context) throws IOException, InterruptedException {
        TypeProtos.Type type = TypeProtos.Type.valueOf((String)this.dedupConf.getEntityType());
        NavigableMap similarRels = value.getFamilyMap(DedupUtils.getSimilarityCFBytes(type));
        if (similarRels != null && !similarRels.isEmpty()) {
            ByteBuffer min = this.findMin(ByteBuffer.wrap(rowkey.get()), similarRels.keySet());
            byte[] row = rowkey.copyBytes();
            byte[] root = DedupUtils.newIdBytes(min, this.dedupConf.getDedupRun());
            System.out.println("Found root: " + new String(root));
            this.emitDedupRel(context, DedupUtils.getDedupCF_mergedInBytes(type), row, root, this.buildRel(row, root, DedupProtos.Dedup.RelName.isMergedIn));
            this.emitDedupRel(context, DedupUtils.getDedupCF_mergesBytes(type), root, row, this.buildRel(root, row, DedupProtos.Dedup.RelName.merges));
            context.getCounter(this.dedupConf.getEntityType(), "dedupRel (x2)").increment(1L);
            this.emitBody(context, row, value.getValue(Bytes.toBytes((String)this.dedupConf.getEntityType()), DedupUtils.BODY_B));
        } else {
            context.getCounter(this.dedupConf.getEntityType(), "row not in similarity mesh").increment(1L);
        }
    }

    private ByteBuffer findMin(ByteBuffer min, Iterable<byte[]> keys) {
        for (byte[] q : keys) {
            ByteBuffer iq = ByteBuffer.wrap(q);
            if (min.compareTo(iq) <= 0) continue;
            min = iq;
        }
        return min;
    }

    private void emitBody(Mapper.Context context, byte[] row, byte[] body) throws InvalidProtocolBufferException, IOException, InterruptedException {
        if (body == null) {
            context.getCounter(this.dedupConf.getEntityType(), "missing body").increment(1L);
            System.err.println("missing body: " + new String(row));
            return;
        }
        OafProtos.Oaf prototype = OafProtos.Oaf.parseFrom((byte[])body);
        if (prototype.getDataInfo().getDeletedbyinference()) {
            context.getCounter(this.dedupConf.getEntityType(), "bodies already deleted").increment(1L);
        } else {
            OafProtos.Oaf.Builder oafRoot = OafProtos.Oaf.newBuilder((OafProtos.Oaf)prototype);
            oafRoot.getDataInfoBuilder().setDeletedbyinference(true).setInferred(true).setInferenceprovenance("dedup");
            byte[] family = Bytes.toBytes((String)this.dedupConf.getEntityType());
            Put put = new Put(row).add(family, DedupUtils.BODY_B, oafRoot.build().toByteArray());
            put.setWriteToWAL(false);
            context.write((Object)new ImmutableBytesWritable(row), (Object)put);
            context.getCounter(this.dedupConf.getEntityType(), "bodies marked deleted").increment(1L);
        }
    }

    private byte[] buildRel(byte[] from, byte[] to, DedupProtos.Dedup.RelName relClass) {
        OafProtos.OafRel.Builder oafRel = DedupUtils.getDedup(this.dedupConf, new String(from), new String(to), relClass);
        OafProtos.Oaf oaf = OafProtos.Oaf.newBuilder().setKind(KindProtos.Kind.relation).setTimestamp(System.currentTimeMillis()).setDataInfo(AbstractDNetOafXsltFunctions.getDataInfo(null, (String)"0.8", (boolean)false, (boolean)true).setInferenceprovenance("dedup")).setRel(oafRel).build();
        return oaf.toByteArray();
    }

    private void emitDedupRel(Mapper.Context context, byte[] cf, byte[] from, byte[] to, byte[] value) throws IOException, InterruptedException {
        Put put = new Put(from).add(cf, to, value);
        context.write((Object)new ImmutableBytesWritable(from), (Object)put);
    }
}

