/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import eu.dnetlib.data.mapreduce.hbase.AbstractHBaseMapReduceJob;
import eu.dnetlib.data.mapreduce.hbase.dedup.DedupGrouperMapper;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.pace.util.DedupConfig;
import eu.dnetlib.pace.util.DedupConfigLoader;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;

public class DedupGrouperJob
extends AbstractHBaseMapReduceJob {
    @Override
    public Job setJobDetails(Job job, Properties p) {
        this.initMapper(job, this.getScan(p), p.getProperty("hbase.source.table"));
        job.setOutputFormatClass(TableOutputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Put.class);
        job.setNumReduceTasks(0);
        job.getConfiguration().setBoolean("mapred.map.tasks.speculative.execution", false);
        job.getConfiguration().setBoolean("mapreduce.map.speculative", false);
        return job;
    }

    private Scan getScan(Properties p) {
        Scan scan = new Scan();
        scan.setCaching(500);
        scan.setCacheBlocks(false);
        DedupConfig dedupConfig = DedupConfigLoader.load((String)p.getProperty("dedup.wf.conf"));
        TypeProtos.Type type = TypeProtos.Type.valueOf((String)dedupConfig.getEntityType());
        scan.setFilter((Filter)new PrefixFilter(Bytes.toBytes((int)type.getNumber())));
        scan.addFamily(DedupUtils.getSimilarityCFBytes(type));
        return scan;
    }

    private void initMapper(Job job, Scan scan, String sourceTable) {
        try {
            TableMapReduceUtil.initTableMapperJob((String)sourceTable, (Scan)scan, DedupGrouperMapper.class, Text.class, Put.class, (Job)job);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

