package eu.dnetlib.data.mapreduce.hbase.broker;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;

import com.google.common.collect.Maps;

public class CalculatePersonDistributionReducer extends TableReducer<Text, ImmutableBytesWritable, NullWritable> {

	private static final int MIN_PUBLICATIONS = 10;
	private static final int MIN_PUBLICATIONS_IN_REPO = 4;

	@Override
	protected void setup(final Context context) throws IOException, InterruptedException {
		super.setup(context);
	}

	@Override
	protected void reduce(final Text key, final Iterable<ImmutableBytesWritable> values, final Context context)
			throws IOException, InterruptedException {

		int total = 0;
		final Map<String, Integer> map = Maps.newHashMap();
		for (ImmutableBytesWritable i : values) {
			final String collectedFrom = Bytes.toString(i.get());
			final Integer count = map.get(collectedFrom);
			map.put(collectedFrom, count == null ? 1 : count + 1);
			total++;
		}

		if (total >= MIN_PUBLICATIONS) {
			final Integer max = Collections.max(map.values());
			if (max >= MIN_PUBLICATIONS_IN_REPO) {
				final int perc = 100 * max / total;
				context.getCounter("Max percentage of results in a repo", StringUtils.leftPad(String.valueOf(perc), 3, "0") + " %").increment(1);;
			}
		}
	}
}
