package eu.dnetlib.data.mapreduce.hbase.dataimport;

import java.io.IOException;

import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;

import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.TypeProtos.Type;

public class CoAuthorMapper extends TableMapper<ImmutableBytesWritable, ImmutableBytesWritable> {

	// private static final Log log = LogFactory.getLog(CoAuthorMapper.class);

	private ImmutableBytesWritable ibw;

	@Override
	protected void setup(final Context context) throws IOException, InterruptedException {
		ibw = new ImmutableBytesWritable();
	}

	@Override
	protected void map(final ImmutableBytesWritable keyIn, final Result result, final Context context) throws IOException, InterruptedException {
		// log.info("got key: " + new String(keyIn.copyBytes()));

		final OafRowKeyDecoder keyDecoder = OafRowKeyDecoder.decode(keyIn.copyBytes());

		switch (keyDecoder.getType()) {
		case person:
			for (final KeyValue kv : result.list()) {
				final String cf = new String(kv.getFamily());
				if (cf.equals(Type.person.toString()) || cf.equals(Type.result.toString())) {
					ibw.set(kv.getValue());
					context.write(keyIn, ibw);
				} else {
					context.getCounter(cf, "skipped family type (map)").increment(1);
				}
			}
			break;
		default:
			context.getCounter("coauthor", "skipped entity type (map)").increment(1);
			break;
		}

	}

}
