/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.actions;

import eu.dnetlib.data.mapreduce.hbase.AbstractHBaseMapReduceJob;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;

public abstract class AbstractActionsJob
extends AbstractHBaseMapReduceJob {
    @Override
    protected Job setJobDetails(Job job, Properties p) throws Exception {
        this.initMapper(job, this.getScan(p), p.getProperty("hbase.source.table"));
        job.setOutputFormatClass(TableOutputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(this.getMapOutputValueClass());
        job.setNumReduceTasks(0);
        return job;
    }

    private void initMapper(Job job, Scan scan, String sourceTable) {
        try {
            TableMapReduceUtil.initTableMapperJob((String)sourceTable, (Scan)scan, this.getMapperClass(), Text.class, ImmutableBytesWritable.class, (Job)job);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract Class<? extends TableMapper<ImmutableBytesWritable, ?>> getMapperClass();

    protected abstract Class<?> getMapOutputValueClass();

    protected abstract void addSpecificFilters(FilterList var1);

    protected abstract void addSpecificScanClauses(Scan var1);

    private Scan getScan(Properties p) {
        Scan scan = new Scan();
        scan.setCaching(500);
        scan.setCacheBlocks(false);
        FilterList filters = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        this.addSpecificFilters(filters);
        this.addSpecificScanClauses(scan);
        scan.setFilter((Filter)filters);
        return scan;
    }
}

