/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce;

import com.typesafe.config.Config;
import java.util.List;

public class OptionalConfig {
    private Config config;

    public OptionalConfig(Config config) {
        this.config = config;
    }

    protected Object safe(String path) {
        return this.config.hasPath(path) ? this.config.getAnyRef(path) : null;
    }

    public Integer getInt(String path) {
        return (Integer)this.safe(path);
    }

    public String getString(String path) {
        return (String)this.safe(path);
    }

    public <T> List<T> getList(String path) {
        return (List)this.safe(path);
    }

    public Double getDouble(String path) {
        Object safe = this.safe(path);
        if (safe instanceof Integer) {
            return Double.parseDouble(safe.toString());
        }
        return (Double)safe;
    }

    public Object getObject(String path) {
        return this.safe(path);
    }

    public Boolean getBoolean(String path) {
        return (Boolean)this.safe(path);
    }

    public Boolean hasPath(String path) {
        return this.getConfig().hasPath(path);
    }

    public Config getConfig() {
        return this.config;
    }
}

