/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataimport;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class DeleteRecordsMapper
extends TableMapper<ImmutableBytesWritable, Delete> {
    private Set<String> delPrefix;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.delPrefix = this.extractPrefixes(context.getConfiguration().get("nsPrefix"));
        String table = context.getConfiguration().get("hbase.source.table").trim();
        System.out.println("I start to delete records (table=" + table + ", prefixes=" + this.delPrefix);
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        byte[] bkey = key.get();
        System.out.println("EVALUATING " + Bytes.toString((byte[])bkey));
        if (this.testValue(bkey)) {
            context.write((Object)key, (Object)new Delete(bkey));
            System.out.println("   --- DELETED");
            context.getCounter("MDStore Cleaner", "Deleted records").increment(1L);
        } else {
            for (KeyValue kv : value.list()) {
                byte[] col = kv.getQualifier();
                if (!this.testValue(col)) continue;
                Delete d = new Delete(bkey);
                d.deleteColumns(kv.getFamily(), col);
                context.write((Object)key, (Object)d);
                System.out.println("   --- DELETED COLUMN: " + Bytes.toString((byte[])col));
                context.getCounter("MDStore Cleaner", "Deleted columns").increment(1L);
            }
        }
    }

    private Set<String> extractPrefixes(String s) {
        return Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)s));
    }

    private boolean testValue(byte[] bkey) {
        String s = Bytes.toString((byte[])bkey);
        if (s.contains("|") && s.contains("::")) {
            return this.delPrefix.contains(s.substring(s.indexOf("|") + 1, s.indexOf("::")));
        }
        if (s.contains("::")) {
            return this.delPrefix.contains(s.substring(0, s.indexOf("::")));
        }
        return false;
    }
}

