package eu.dnetlib.data.mapreduce.hbase.dataimport;

import java.io.IOException;

import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

import eu.dnetlib.data.mapreduce.JobParams;

public class SequenceFileRecordMapper extends Mapper<Text, Text, ImmutableBytesWritable, Put> {

	private String family;

	private String qualifier;
	
	@Override
	protected void setup(Context context) throws IOException, InterruptedException {
		super.setup(context);
		
		this.family = context.getConfiguration().get(JobParams.HBASE_TARGET_FAMILY).trim();
		this.qualifier = context.getConfiguration().get(JobParams.HBASE_TARGET_QUALIFIER).trim();
	}
	
	@Override
	protected void map(Text key, Text value, Context context) throws IOException, InterruptedException {

		//byte[] rowKey = DigestUtils.md5(key.toString());
		byte[] rowKey = Bytes.toBytes(key.toString());
		
		Put put = new Put(rowKey).add(Bytes.toBytes(family), Bytes.toBytes(qualifier), Bytes.toBytes(value.toString()));
	
        context.write(new ImmutableBytesWritable(rowKey), put);
	}

}
