/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.actions2;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class PromoteActionsMapper
extends TableMapper<ImmutableBytesWritable, Put> {
    private static final String LATEST_RAW_SETS = "latestRawSets";
    private Set<byte[]> latestRawSets = Sets.newHashSet();

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        String s = context.getConfiguration().get(LATEST_RAW_SETS);
        if (s != null) {
            for (String set : Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)s))) {
                this.latestRawSets.add(Bytes.toBytes((String)set));
            }
        }
        if (this.latestRawSets.isEmpty()) {
            throw new IOException("Input parameter (latestRawSets) is missing or empty: " + s);
        }
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        for (byte[] s1 : value.getFamilyMap(Bytes.toBytes((String)"set")).keySet()) {
            for (byte[] s2 : this.latestRawSets) {
                if (!Bytes.equals((byte[])s1, (byte[])s2)) continue;
                this.promoteAction(value, context);
            }
        }
    }

    private void promoteAction(Result value, Mapper.Context context) throws IOException, InterruptedException {
        byte[] cf = Bytes.toBytes((String)"target");
        byte[] tkey = value.getValue(cf, Bytes.toBytes((String)"rowKey"));
        byte[] tcf = value.getValue(cf, Bytes.toBytes((String)"columnFamily"));
        byte[] tc = value.getValue(cf, Bytes.toBytes((String)"column"));
        byte[] tv = value.getValue(cf, Bytes.toBytes((String)"content"));
        Put put = new Put(tkey);
        put.add(tcf, tc, tv);
        context.getCounter("Actions", Bytes.toString((byte[])tcf)).increment(1L);
        context.write((Object)new ImmutableBytesWritable(tkey), (Object)put);
    }
}

