/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class CalculatePersonDistributionReducer
extends TableReducer<Text, ImmutableBytesWritable, NullWritable> {
    private static final int MIN_PUBLICATIONS = 10;
    private static final int MIN_PUBLICATIONS_IN_REPO = 4;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
    }

    protected void reduce(Text key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        Integer max;
        int total = 0;
        HashMap map = Maps.newHashMap();
        for (ImmutableBytesWritable i : values) {
            String collectedFrom;
            Integer count = (Integer)map.get(collectedFrom = Bytes.toString((byte[])i.get()));
            map.put(collectedFrom, count == null ? 1 : count + 1);
            ++total;
        }
        if (total >= 10 && (max = (Integer)Collections.max(map.values())) >= 4) {
            int perc = 100 * max / total;
            context.getCounter("Max percentage of results in a repo", StringUtils.leftPad((String)String.valueOf(perc), (int)3, (String)"0") + " %").increment(1L);
        }
    }
}

