/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.oai.config;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.dnetlib.data.mapreduce.hbase.oai.utils.MDFInfo;
import eu.dnetlib.data.mapreduce.hbase.oai.utils.PublisherField;
import eu.dnetlib.data.mapreduce.hbase.oai.utils.SetInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OAIConfiguration {
    private Map<String, SetInfo> setsMap;
    private Map<String, MDFInfo> mdFormatsMap;
    private List<PublisherField> fields;
    private List<String> fieldNames;
    private String idScheme;
    private String idNamespace;
    private Set<MDFInfo> sourcesMDF = Sets.newHashSet();
    private Multimap<String, String> enrichmentXPaths;

    public Collection<PublisherField> getFieldsFor(String format, String layout, String interpretation) {
        final String mdRef = Joiner.on((String)"-").join((Object)format, (Object)layout, new Object[]{interpretation});
        return Collections2.filter(this.getFields(), (Predicate)new Predicate<PublisherField>(){

            public boolean apply(PublisherField theField) {
                if (theField.getSources() == null) {
                    return false;
                }
                return theField.getSources().containsKey((Object)mdRef);
            }
        });
    }

    public Collection<String> getEnrichmentXPathsFor(String format, String layout, String interpretation) {
        String mdRef = Joiner.on((String)"-").join((Object)format, (Object)layout, new Object[]{interpretation});
        return this.enrichmentXPaths.get((Object)mdRef);
    }

    public Map<String, SetInfo> getSetsMap() {
        return this.setsMap;
    }

    public void setSetsMap(Map<String, SetInfo> setsMap) {
        this.setsMap = setsMap;
    }

    public Map<String, MDFInfo> getMdFormatsMap() {
        return this.mdFormatsMap;
    }

    public void setMdFormatsMap(Map<String, MDFInfo> mdFormatsMap) {
        this.mdFormatsMap = mdFormatsMap;
    }

    public List<PublisherField> getFields() {
        return this.fields;
    }

    public void setFields(List<PublisherField> fields) {
        this.fields = fields;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public void setFieldNames(List<String> fieldNames) {
        this.fieldNames = fieldNames;
    }

    public Set<MDFInfo> getSourcesMDF() {
        return this.sourcesMDF;
    }

    public void setSourcesMDF(Set<MDFInfo> sourcesMDF) {
        this.sourcesMDF = sourcesMDF;
    }

    public String getIdScheme() {
        return this.idScheme;
    }

    public void setIdScheme(String idScheme) {
        this.idScheme = idScheme;
    }

    public String getIdNamespace() {
        return this.idNamespace;
    }

    public void setIdNamespace(String idNamespace) {
        this.idNamespace = idNamespace;
    }

    public Multimap<String, String> getEnrichmentXPaths() {
        return this.enrichmentXPaths;
    }

    public void setEnrichmentXPaths(Multimap<String, String> enrichmentXPaths) {
        this.enrichmentXPaths = enrichmentXPaths;
    }

    public String toString() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((Object)this);
    }
}

