package eu.dnetlib.data.mapreduce.hbase.dedup.gt;

import java.io.IOException;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;

public class BuildMergedAnchorMapReducer extends Reducer<ImmutableBytesWritable, Text, Text, Text> {

	private Text outKey;

	private Text outValue;

	@SuppressWarnings("serial")
	final java.lang.reflect.Type token = new TypeToken<Map<String, String>>() {}.getType();

	private Gson gson;

	@Override
	protected void setup(final Context context) throws IOException, InterruptedException {
		gson = new Gson();

		outKey = new Text();
		outValue = new Text();
	}

	@Override
	protected void reduce(final ImmutableBytesWritable key, final Iterable<Text> values, final Context context) throws IOException, InterruptedException {

		for (final Text json : values) {
			final Map<String, String> map = gson.fromJson(json.toString(), token);
			for (final Entry<String, String> e : map.entrySet()) {

				outKey.set(e.getKey());
				outValue.set(e.getValue());

				context.write(outKey, outValue);
			}
		}
	}

}
