/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.ResultProtos;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class CalculatePersonDistributionMapper
extends TableMapper<Text, ImmutableBytesWritable> {
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
    }

    protected void map(ImmutableBytesWritable key, Result result, Mapper.Context context) throws IOException, InterruptedException {
        if (DedupUtils.isRoot(key)) {
            return;
        }
        byte[] body = result.getValue(Bytes.toBytes((String)"result"), Bytes.toBytes((String)"body"));
        if (body == null) {
            return;
        }
        OafProtos.Oaf oaf = OafProtos.Oaf.parseFrom((byte[])body);
        ResultProtos.Result r = oaf.getEntity().getResult();
        if (r != null) {
            for (PersonProtos.Person p : r.getAuthorList()) {
                String name = p.getMetadata().getFullname().getValue();
                for (FieldTypeProtos.KeyValue kv : oaf.getEntity().getCollectedfromList()) {
                    context.write((Object)new Text(name), (Object)new ImmutableBytesWritable(Bytes.toBytes((String)kv.getKey())));
                }
            }
        }
    }
}

