/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataimport;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.Column;
import eu.dnetlib.data.transform.Row;
import eu.dnetlib.data.transform.XsltRowTransformer;
import eu.dnetlib.data.transform.XsltRowTransformerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class AuthorImportRecordsMapper
extends Mapper<Text, Text, ImmutableBytesWritable, Put> {
    private static final Log log = LogFactory.getLog(AuthorImportRecordsMapper.class);
    private static final boolean WRITE_TO_WAL = false;
    private XsltRowTransformer transformer;
    private ImmutableBytesWritable ibw;
    private Map<String, String> merged;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        String xslt = context.getConfiguration().get("hbase.import.xslt").trim();
        if (xslt == null || xslt.isEmpty()) {
            throw new IllegalArgumentException("missing xslt");
        }
        HashMap xslParams = Maps.newHashMap();
        if (context.getConfiguration().get("datasourceTypeMap") != null) {
            Map<String, String> dsMap = this.getDatasourceTypeMap(context);
            log.info((Object)("using datasource type map:\n" + dsMap.toString()));
            xslParams.put("mergeIdForHomonymsMap", dsMap);
        }
        this.transformer = XsltRowTransformerFactory.newInstance((String)xslt, (Map)xslParams);
        this.ibw = new ImmutableBytesWritable();
        this.merged = this.loadMap(context.getConfiguration());
        log.info((Object)("map { native id --> anchor id } size: " + this.merged.size()));
        log.info((Object)("got xslt: '" + xslt));
        log.info((Object)("using trasformer: '" + this.transformer.getTransformerClassName() + "'"));
    }

    protected void map(Text key, Text value, final Mapper.Context context) throws IOException, InterruptedException {
        try {
            List rowList = this.transformer.apply(value.toString());
            context.getCounter("mdstore", "person (from mdstore)").increment((long)rowList.size());
            Iterable oafBuilders = Iterables.transform((Iterable)rowList, (Function)new Function<Row, OafProtos.Oaf.Builder>(){

                public OafProtos.Oaf.Builder apply(Row row) {
                    Column col = row.getColumn("body");
                    OafDecoder d = OafDecoder.decode((byte[])((byte[])col.getValue()));
                    return OafProtos.Oaf.newBuilder((OafProtos.Oaf)d.getOaf());
                }
            });
            Iterable filtered = Iterables.filter((Iterable)oafBuilders, (Predicate)new Predicate<OafProtos.Oaf.Builder>(){

                public boolean apply(OafProtos.Oaf.Builder b) {
                    boolean res = AuthorImportRecordsMapper.this.merged.containsKey(b.getEntity().getId());
                    if (res) {
                        context.getCounter("mdstore", "person (found in anchor map)").increment(1L);
                    }
                    return !res;
                }
            });
            Iterable patched = Iterables.transform((Iterable)filtered, (Function)new Function<OafProtos.Oaf.Builder, Row>(){

                public Row apply(OafProtos.Oaf.Builder b) {
                    for (PersonProtos.Person.CoAuthor.Builder cb : b.getEntityBuilder().getPersonBuilder().getCoauthorBuilderList()) {
                        String anchorId = (String)AuthorImportRecordsMapper.this.merged.get(cb.getId());
                        if (!StringUtils.isNotBlank((String)anchorId)) continue;
                        context.getCounter("mdstore", "person (coAuthor as anchor)").increment(1L);
                        cb.setAnchorId(anchorId);
                    }
                    String family = TypeProtos.Type.person.toString();
                    Row rowout = new Row(family, b.getEntity().getId());
                    rowout.setColumn(family, Column.newInstance((Object)"body", (Object)b.build().toByteArray()));
                    return rowout;
                }
            });
            this.write(context, patched);
        }
        catch (Throwable e) {
            log.error((Object)("error importing the following record on HBase: " + value.toString()), e);
            context.getCounter("error", e.getClass().getName()).increment(1L);
            throw new RuntimeException(e);
        }
    }

    private void write(Mapper.Context context, Iterable<Row> filtered) throws IOException, InterruptedException {
        for (Row row : filtered) {
            byte[] rowKey = Bytes.toBytes((String)row.getKey());
            Put put = new Put(rowKey);
            put.setWriteToWAL(false);
            for (Column col : row) {
                byte[] family = Bytes.toBytes((String)row.getColumnFamily());
                byte[] qualifier = Bytes.toBytes((String)((String)col.getName()));
                put.add(family, qualifier, (byte[])col.getValue());
            }
            this.ibw.set(rowKey);
            context.write((Object)this.ibw, (Object)put);
            context.getCounter("mdstore", row.getColumnFamily()).increment((long)row.getColumns().size());
        }
    }

    private Map<String, String> getDatasourceTypeMap(Mapper.Context context) {
        String dsType = context.getConfiguration().get("datasourceTypeMap");
        Type token = new TypeToken<Map<String, String>>(){}.getType();
        Map dsMap = (Map)new Gson().fromJson(dsType, token);
        return dsMap;
    }

    private Map<String, String> loadMap(Configuration conf) throws IOException {
        HashMap map = Maps.newHashMap();
        String filePath = conf.get("mapred.output.dir") + "/part-r-00000";
        if (StringUtils.isBlank((String)filePath)) {
            throw new IllegalArgumentException("missing 'mapred.output.dir'");
        }
        Path path = new Path(filePath);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)FileSystem.get((Configuration)conf).open(path)));
        String line = br.readLine();
        while (line != null) {
            String[] split = line.split("=");
            map.put(split[0], split[1]);
            line = br.readLine();
        }
        return map;
    }
}

